/* wmputca.c (emx+gcc) -- Copyright (c) 1987-1993 by Eberhard Mattes */

#include <sys/winmgr.h>
#include "winmgr2.h"

void wm_putca (wm_handle wh, char c, int a)
{
  int mx, my;

  mx = wh->x + wh->ax;
  my = wh->y + wh->ay;
  if (wh->display)
    {
      if (wh->visible || MASK (wh, mx, my))
        _wm_putc2 (c, wh->x+wh->x0, wh->y+wh->y0, a);
    }
  else
    wh->update_req = TRUE;
  _wm_store1 (wh, mx, my, c, a);
  if (++wh->x >= wh->width)
    {
      if (wh->wrap)
        {
          wh->x = 0;
          ++wh->y;
        }
      else
        --wh->x;
    }
  if (wh->y >= wh->height)
    {
      --wh->y;
      wm_scroll (wh, 1);
    }
  _wm_cursor1 ();
}
