/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.matching;

import choco.kernel.memory.IEnvironment;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.constraints.global.matching.AbstractBipartiteFlow;
import choco.kernel.solver.variables.integer.IntDomainVar;

public class GlobalCardinality
extends AbstractBipartiteFlow {
    public GlobalCardinality(IntDomainVar[] vars, int minValue, int maxValue, int[] low, int[] up, IEnvironment environment) {
        super(environment, vars, vars.length, maxValue - minValue + 1);
        GlobalCardinality.globalCardinalityTest(vars, minValue, maxValue, low, up);
        this.minValue = minValue;
        this.maxValue = maxValue;
        for (int i = 0; i < this.minFlow.length; ++i) {
            this.minFlow[i] = low[i];
            this.maxFlow[i] = up[i];
        }
    }

    public GlobalCardinality(IntDomainVar[] vars, int[] low, int[] up, IEnvironment environment) {
        super(environment, vars, vars.length, low.length);
        GlobalCardinality.globalCardinalityTest(vars, 1, low.length, low, up);
        this.minValue = 1;
        this.maxValue = low.length;
        for (int i = 0; i < this.minFlow.length; ++i) {
            this.minFlow[i] = low[i];
            this.maxFlow[i] = up[i];
        }
    }

    private static void globalCardinalityTest(IntDomainVar[] vars, int min, int max, int[] low, int[] up) {
        if (low.length != up.length) {
            throw new SolverException("globalCardinality : low and up do not have same size");
        }
        int sumL = 0;
        for (int i = 0; i < low.length; ++i) {
            sumL += low[i];
            if (low[i] <= up[i]) continue;
            throw new SolverException("globalCardinality : incorrect low and up (" + i + ")");
        }
        if (vars.length < sumL) {
            throw new SolverException("globalCardinality : not enough minimum values");
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        GlobalCardinality newc = (GlobalCardinality)super.clone();
        System.arraycopy(this.minFlow, 0, newc.minFlow, 0, this.minFlow.length);
        System.arraycopy(this.maxFlow, 0, newc.maxFlow, 0, this.maxFlow.length);
        return newc;
    }

    @Override
    public void deleteEdgeAndPublish(int i, int j) throws ContradictionException {
        assert (0 <= i && i < this.nbLeftVertices && 0 <= j && j < this.nbRightVertices);
        this.deleteMatch(i, j);
        ((IntDomainVar[])this.vars)[i].removeVal(j + this.minValue, this, false);
    }

    public void setEdgeAndPublish(int i, int j) throws ContradictionException {
        assert (1 <= i && i <= this.nbLeftVertices && 1 <= j && j <= this.nbRightVertices);
        this.setMatch(i, j);
        ((IntDomainVar[])this.vars)[i].instantiate(j + this.minValue, this, false);
    }

    @Override
    public void awakeOnRem(int idx, int x) throws ContradictionException {
        this.deleteEdgeAndPublish(idx, x - this.minValue);
        this.constAwake(false);
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        for (int j = this.minValue; j < ((IntDomainVar[])this.vars)[idx].getInf(); ++j) {
            this.deleteMatch(idx, j - this.minValue);
        }
        this.constAwake(false);
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        for (int j = ((IntDomainVar[])this.vars)[idx].getSup() + 1; j <= this.maxValue; ++j) {
            this.deleteMatch(idx, j - this.minValue);
        }
        this.constAwake(false);
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        this.setMatch(idx, ((IntDomainVar[])this.vars)[idx].getVal() - this.minValue);
        this.constAwake(false);
    }

    @Override
    public void awake() throws ContradictionException {
        this.init();
        for (int i = 0; i < this.nbLeftVertices; ++i) {
            ((IntDomainVar[])this.vars)[i].updateInf(this.minValue, this, false);
            ((IntDomainVar[])this.vars)[i].updateSup(this.maxValue, this, false);
        }
        this.propagate();
    }

    @Override
    public void propagate() throws ContradictionException {
        super.propagate();
        for (int j = 0; j < this.nbRightVertices; ++j) {
            if (this.flow.get(j) <= this.getMaxFlow(j) && this.flow.get(j) >= this.getMinFlow(j)) continue;
            this.fail();
        }
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        int i;
        int[] occurrences = new int[this.maxValue - this.minValue + 1];
        for (i = 0; i < ((IntDomainVar[])this.vars).length; ++i) {
            int n = tuple[i] - this.minValue;
            occurrences[n] = occurrences[n] + 1;
        }
        for (i = 0; i < occurrences.length; ++i) {
            int occurrence = occurrences[i];
            if (this.minFlow[i] <= occurrence && occurrence <= this.maxFlow[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public String pretty() {
        StringBuffer buf = new StringBuffer("GCC[" + ((IntDomainVar[])this.vars).length + "," + (this.maxValue - this.minValue + 1) + "]\n");
        for (int i = 0; i < ((IntDomainVar[])this.vars).length; ++i) {
            buf.append(((IntDomainVar[])this.vars)[i].pretty());
            buf.append("\n");
        }
        return new String(buf);
    }
}

