/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong;

import cern.colt.function.tlong.LongFunction;
import cern.colt.function.tlong.LongLongFunction;
import cern.colt.function.tlong.LongProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.list.tlong.LongArrayList;
import cern.colt.matrix.AbstractMatrix3D;
import cern.colt.matrix.tlong.LongMatrix1D;
import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.LongMatrix2DProcedure;
import cern.colt.matrix.tlong.algo.LongFormatter;
import cern.colt.matrix.tlong.algo.LongProperty;
import cern.colt.matrix.tlong.algo.LongSorting;
import cern.jet.math.tlong.LongFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class LongMatrix3D
extends AbstractMatrix3D {
    private static final long serialVersionUID = 1L;

    protected LongMatrix3D() {
    }

    public long aggregate(final LongLongFunction longLongFunction, final LongFunction longFunction) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        long l = 0L;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long l = longFunction.apply(LongMatrix3D.this.getQuick(n3, 0, 0));
                        int n = 1;
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < LongMatrix3D.this.rows; ++j) {
                                for (int k = n; k < LongMatrix3D.this.columns; ++k) {
                                    l = longLongFunction.apply(l, longFunction.apply(LongMatrix3D.this.getQuick(i, j, k)));
                                }
                                n = 0;
                            }
                        }
                        return l;
                    }
                });
            }
            l = ConcurrencyUtils.waitForCompletion(futureArray, longLongFunction);
        } else {
            l = longFunction.apply(this.getQuick(0, 0, 0));
            int n5 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n5; k < this.columns; ++k) {
                        l = longLongFunction.apply(l, longFunction.apply(this.getQuick(i, j, k)));
                    }
                    n5 = 0;
                }
            }
        }
        return l;
    }

    public long aggregate(final LongLongFunction longLongFunction, final LongFunction longFunction, final LongProcedure longProcedure) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        long l = 0L;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long l = LongMatrix3D.this.getQuick(n3, 0, 0);
                        long l2 = 0L;
                        if (longProcedure.apply(l)) {
                            l2 = longLongFunction.apply(l2, longFunction.apply(l));
                        }
                        int n = 1;
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < LongMatrix3D.this.rows; ++j) {
                                for (int k = n; k < LongMatrix3D.this.columns; ++k) {
                                    l = LongMatrix3D.this.getQuick(i, j, k);
                                    if (longProcedure.apply(l)) {
                                        l2 = longLongFunction.apply(l2, longFunction.apply(l));
                                    }
                                    n = 0;
                                }
                            }
                        }
                        return l2;
                    }
                });
            }
            l = ConcurrencyUtils.waitForCompletion(futureArray, longLongFunction);
        } else {
            long l2 = this.getQuick(0, 0, 0);
            if (longProcedure.apply(l2)) {
                l = longLongFunction.apply(l, longFunction.apply(l2));
            }
            int n5 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n5; k < this.columns; ++k) {
                        l2 = this.getQuick(i, j, k);
                        if (longProcedure.apply(l2)) {
                            l = longLongFunction.apply(l, longFunction.apply(l2));
                        }
                        n5 = 0;
                    }
                }
            }
        }
        return l;
    }

    public long aggregate(final LongLongFunction longLongFunction, final LongFunction longFunction, IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        if (intArrayList.size() == 0 || intArrayList2.size() == 0 || intArrayList3.size() == 0) {
            throw new IllegalArgumentException("size == 0");
        }
        int n = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        final int[] nArray2 = intArrayList2.elements();
        final int[] nArray3 = intArrayList3.elements();
        long l = 0L;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n2 = Math.min(n2, n);
            Future[] futureArray = new Future[n2];
            int n3 = n / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? n : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long l = longFunction.apply(LongMatrix3D.this.getQuick(nArray[n4], nArray2[n4], nArray3[n4]));
                        for (int i = n4 + 1; i < n5; ++i) {
                            long l2 = LongMatrix3D.this.getQuick(nArray[i], nArray2[i], nArray3[i]);
                            l = longLongFunction.apply(l, longFunction.apply(l2));
                        }
                        return l;
                    }
                });
            }
            l = ConcurrencyUtils.waitForCompletion(futureArray, longLongFunction);
        } else {
            l = longFunction.apply(this.getQuick(nArray[0], nArray2[0], nArray3[0]));
            for (int i = 1; i < n; ++i) {
                long l2 = this.getQuick(nArray[i], nArray2[i], nArray3[i]);
                l = longLongFunction.apply(l, longFunction.apply(l2));
            }
        }
        return l;
    }

    public long aggregate(final LongMatrix3D longMatrix3D, final LongLongFunction longLongFunction, final LongLongFunction longLongFunction2) {
        this.checkShape(longMatrix3D);
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        long l = 0L;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long l = longLongFunction2.apply(LongMatrix3D.this.getQuick(n3, 0, 0), longMatrix3D.getQuick(n3, 0, 0));
                        int n = 1;
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < LongMatrix3D.this.rows; ++j) {
                                for (int k = n; k < LongMatrix3D.this.columns; ++k) {
                                    l = longLongFunction.apply(l, longLongFunction2.apply(LongMatrix3D.this.getQuick(i, j, k), longMatrix3D.getQuick(i, j, k)));
                                }
                                n = 0;
                            }
                        }
                        return l;
                    }
                });
            }
            l = ConcurrencyUtils.waitForCompletion(futureArray, longLongFunction);
        } else {
            l = longLongFunction2.apply(this.getQuick(0, 0, 0), longMatrix3D.getQuick(0, 0, 0));
            int n5 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n5; k < this.columns; ++k) {
                        l = longLongFunction.apply(l, longLongFunction2.apply(this.getQuick(i, j, k), longMatrix3D.getQuick(i, j, k)));
                    }
                    n5 = 0;
                }
            }
        }
        return l;
    }

    public LongMatrix3D assign(final LongFunction longFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < LongMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < LongMatrix3D.this.columns; ++k) {
                                    LongMatrix3D.this.setQuick(i, j, k, longFunction.apply(LongMatrix3D.this.getQuick(i, j, k)));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        this.setQuick(i, j, k, longFunction.apply(this.getQuick(i, j, k)));
                    }
                }
            }
        }
        return this;
    }

    public LongMatrix3D assign(final long l) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < LongMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < LongMatrix3D.this.columns; ++k) {
                                    LongMatrix3D.this.setQuick(i, j, k, l);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        this.setQuick(i, j, k, l);
                    }
                }
            }
        }
        return this;
    }

    public LongMatrix3D assign(final long[] lArray) {
        if (lArray.length != this.slices * this.rows * this.columns) {
            throw new IllegalArgumentException("Must have same length: length=" + lArray.length + "slices()*rows()*columns()=" + this.slices() * this.rows() * this.columns());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n3 * LongMatrix3D.this.rows * LongMatrix3D.this.columns;
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < LongMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < LongMatrix3D.this.columns; ++k) {
                                    LongMatrix3D.this.setQuick(i, j, k, lArray[n++]);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n5 = 0;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        this.setQuick(i, j, k, lArray[n5++]);
                    }
                }
            }
        }
        return this;
    }

    public LongMatrix3D assign(final int[] nArray) {
        if (nArray.length != this.slices * this.rows * this.columns) {
            throw new IllegalArgumentException("Must have same length: length=" + nArray.length + "slices()*rows()*columns()=" + this.slices() * this.rows() * this.columns());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n3 * LongMatrix3D.this.rows * LongMatrix3D.this.columns;
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < LongMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < LongMatrix3D.this.columns; ++k) {
                                    LongMatrix3D.this.setQuick(i, j, k, nArray[n++]);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n5 = 0;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        this.setQuick(i, j, k, nArray[n5++]);
                    }
                }
            }
        }
        return this;
    }

    public LongMatrix3D assign(final long[][][] lArray) {
        if (lArray.length != this.slices) {
            throw new IllegalArgumentException("Must have same number of slices: slices=" + lArray.length + "slices()=" + this.slices());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            long[][] lArray3 = lArray[i];
                            if (lArray3.length != LongMatrix3D.this.rows) {
                                throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + lArray3.length + "rows()=" + LongMatrix3D.this.rows());
                            }
                            for (int j = 0; j < LongMatrix3D.this.rows; ++j) {
                                long[] lArray2 = lArray3[j];
                                if (lArray2.length != LongMatrix3D.this.columns) {
                                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + lArray2.length + "columns()=" + LongMatrix3D.this.columns());
                                }
                                for (int k = 0; k < LongMatrix3D.this.columns; ++k) {
                                    LongMatrix3D.this.setQuick(i, j, k, lArray2[k]);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                long[][] lArray2 = lArray[i];
                if (lArray2.length != this.rows) {
                    throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + lArray2.length + "rows()=" + this.rows());
                }
                for (int j = 0; j < this.rows; ++j) {
                    long[] lArray3 = lArray2[j];
                    if (lArray3.length != this.columns) {
                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + lArray3.length + "columns()=" + this.columns());
                    }
                    for (int k = 0; k < this.columns; ++k) {
                        this.setQuick(i, j, k, lArray3[k]);
                    }
                }
            }
        }
        return this;
    }

    public LongMatrix3D assign(final LongProcedure longProcedure, final LongFunction longFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < LongMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < LongMatrix3D.this.columns; ++k) {
                                    long l = LongMatrix3D.this.getQuick(i, j, k);
                                    if (!longProcedure.apply(l)) continue;
                                    LongMatrix3D.this.setQuick(i, j, k, longFunction.apply(l));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        long l = this.getQuick(i, j, k);
                        if (!longProcedure.apply(l)) continue;
                        this.setQuick(i, j, k, longFunction.apply(l));
                    }
                }
            }
        }
        return this;
    }

    public LongMatrix3D assign(final LongProcedure longProcedure, final long l) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < LongMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < LongMatrix3D.this.columns; ++k) {
                                    long l2 = LongMatrix3D.this.getQuick(i, j, k);
                                    if (!longProcedure.apply(l2)) continue;
                                    LongMatrix3D.this.setQuick(i, j, k, l);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        long l2 = this.getQuick(i, j, k);
                        if (!longProcedure.apply(l2)) continue;
                        this.setQuick(i, j, k, l);
                    }
                }
            }
        }
        return this;
    }

    public LongMatrix3D assign(LongMatrix3D longMatrix3D) {
        if (longMatrix3D == this) {
            return this;
        }
        this.checkShape(longMatrix3D);
        final LongMatrix3D longMatrix3D2 = this.haveSharedCells(longMatrix3D) ? longMatrix3D.copy() : longMatrix3D;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < LongMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < LongMatrix3D.this.columns; ++k) {
                                    LongMatrix3D.this.setQuick(i, j, k, longMatrix3D2.getQuick(i, j, k));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        this.setQuick(i, j, k, longMatrix3D2.getQuick(i, j, k));
                    }
                }
            }
        }
        return this;
    }

    public LongMatrix3D assign(final LongMatrix3D longMatrix3D, final LongLongFunction longLongFunction) {
        this.checkShape(longMatrix3D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < LongMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < LongMatrix3D.this.columns; ++k) {
                                    LongMatrix3D.this.setQuick(i, j, k, longLongFunction.apply(LongMatrix3D.this.getQuick(i, j, k), longMatrix3D.getQuick(i, j, k)));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        this.setQuick(i, j, k, longLongFunction.apply(this.getQuick(i, j, k), longMatrix3D.getQuick(i, j, k)));
                    }
                }
            }
        }
        return this;
    }

    public LongMatrix3D assign(final LongMatrix3D longMatrix3D, final LongLongFunction longLongFunction, IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3) {
        this.checkShape(longMatrix3D);
        int n = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        final int[] nArray2 = intArrayList2.elements();
        final int[] nArray3 = intArrayList3.elements();
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n2 = Math.min(n2, n);
            Future[] futureArray = new Future[n2];
            int n3 = n / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? n : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            LongMatrix3D.this.setQuick(nArray[i], nArray2[i], nArray3[i], longLongFunction.apply(LongMatrix3D.this.getQuick(nArray[i], nArray2[i], nArray3[i]), longMatrix3D.getQuick(nArray[i], nArray2[i], nArray3[i])));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < n; ++i) {
                this.setQuick(nArray[i], nArray2[i], nArray3[i], longLongFunction.apply(this.getQuick(nArray[i], nArray2[i], nArray3[i]), longMatrix3D.getQuick(nArray[i], nArray2[i], nArray3[i])));
            }
        }
        return this;
    }

    public int cardinality() {
        int n = 0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            int n3;
            n2 = Math.min(n2, this.slices);
            Future[] futureArray = new Future[n2];
            Integer[] integerArray = new Integer[n2];
            int n4 = this.slices / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? this.slices : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        for (int i = n5; i < n6; ++i) {
                            for (int j = 0; j < LongMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < LongMatrix3D.this.columns; ++k) {
                                    if (LongMatrix3D.this.getQuick(i, j, k) == 0L) continue;
                                    ++n;
                                }
                            }
                        }
                        return n;
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    integerArray[n3] = (Integer)futureArray[n3].get();
                }
                n = integerArray[0];
                for (n3 = 1; n3 < n2; ++n3) {
                    n += integerArray[n3].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        if (this.getQuick(i, j, k) == 0L) continue;
                        ++n;
                    }
                }
            }
        }
        return n;
    }

    public LongMatrix3D copy() {
        return this.like().assign(this);
    }

    public abstract Object elements();

    public boolean equals(long l) {
        return LongProperty.DEFAULT.equals(this, l);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof LongMatrix3D)) {
            return false;
        }
        return LongProperty.DEFAULT.equals(this, (LongMatrix3D)object);
    }

    public long get(int n, int n2, int n3) {
        if (n < 0 || n >= this.slices || n2 < 0 || n2 >= this.rows || n3 < 0 || n3 >= this.columns) {
            throw new IndexOutOfBoundsException("slice:" + n + ", row:" + n2 + ", column:" + n3);
        }
        return this.getQuick(n, n2, n3);
    }

    protected LongMatrix3D getContent() {
        return this;
    }

    public void getNegativeValues(IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3, LongArrayList longArrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        intArrayList3.clear();
        longArrayList.clear();
        for (int i = 0; i < this.slices; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                for (int k = 0; k < this.columns; ++k) {
                    long l = this.getQuick(i, j, k);
                    if (l >= 0L) continue;
                    intArrayList.add(i);
                    intArrayList2.add(j);
                    intArrayList3.add(k);
                    longArrayList.add(l);
                }
            }
        }
    }

    public void getNonZeros(IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3, LongArrayList longArrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        intArrayList3.clear();
        longArrayList.clear();
        for (int i = 0; i < this.slices; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                for (int k = 0; k < this.columns; ++k) {
                    long l = this.getQuick(i, j, k);
                    if (l == 0L) continue;
                    intArrayList.add(i);
                    intArrayList2.add(j);
                    intArrayList3.add(k);
                    longArrayList.add(l);
                }
            }
        }
    }

    public void getPositiveValues(IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3, LongArrayList longArrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        intArrayList3.clear();
        longArrayList.clear();
        for (int i = 0; i < this.slices; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                for (int k = 0; k < this.columns; ++k) {
                    long l = this.getQuick(i, j, k);
                    if (l <= 0L) continue;
                    intArrayList.add(i);
                    intArrayList2.add(j);
                    intArrayList3.add(k);
                    longArrayList.add(l);
                }
            }
        }
    }

    public abstract long getQuick(int var1, int var2, int var3);

    protected boolean haveSharedCells(LongMatrix3D longMatrix3D) {
        if (longMatrix3D == null) {
            return false;
        }
        if (this == longMatrix3D) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(longMatrix3D.getContent());
    }

    protected boolean haveSharedCellsRaw(LongMatrix3D longMatrix3D) {
        return false;
    }

    public LongMatrix3D like() {
        return this.like(this.slices, this.rows, this.columns);
    }

    public abstract LongMatrix3D like(int var1, int var2, int var3);

    public abstract LongMatrix2D like2D(int var1, int var2);

    protected abstract LongMatrix2D like2D(int var1, int var2, int var3, int var4, int var5, int var6);

    public long[] getMaxLocation() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        long l = 0L;
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            int n5;
            n4 = Math.min(n4, this.slices);
            Future[] futureArray = new Future[n4];
            long[][] lArray = new long[n4][2];
            int n6 = this.slices / n4;
            for (n5 = 0; n5 < n4; ++n5) {
                final int n7 = n5 * n6;
                final int n8 = n5 == n4 - 1 ? this.slices : n7 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Callable<long[]>(){

                    @Override
                    public long[] call() throws Exception {
                        int n = n7;
                        int n2 = 0;
                        int n3 = 0;
                        long l = LongMatrix3D.this.getQuick(n, 0, 0);
                        int n4 = 1;
                        for (int i = n7; i < n8; ++i) {
                            for (int j = 0; j < LongMatrix3D.this.rows; ++j) {
                                for (int k = n4; k < LongMatrix3D.this.columns; ++k) {
                                    long l2 = LongMatrix3D.this.getQuick(i, j, k);
                                    if (l >= l2) continue;
                                    l = l2;
                                    n = i;
                                    n2 = j;
                                    n3 = k;
                                }
                                n4 = 0;
                            }
                        }
                        return new long[]{l, n, n2, n3};
                    }
                });
            }
            try {
                for (n5 = 0; n5 < n4; ++n5) {
                    lArray[n5] = (long[])futureArray[n5].get();
                }
                l = lArray[0][0];
                n = (int)lArray[0][1];
                n2 = (int)lArray[0][2];
                n3 = (int)lArray[0][3];
                for (n5 = 1; n5 < n4; ++n5) {
                    if (l >= lArray[n5][0]) continue;
                    l = lArray[n5][0];
                    n = (int)lArray[n5][1];
                    n2 = (int)lArray[n5][2];
                    n3 = (int)lArray[n5][3];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            l = this.getQuick(0, 0, 0);
            int n9 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n9; k < this.columns; ++k) {
                        long l2 = this.getQuick(i, j, k);
                        if (l >= l2) continue;
                        l = l2;
                        n = i;
                        n2 = j;
                        n3 = k;
                    }
                    n9 = 0;
                }
            }
        }
        return new long[]{l, n, n2, n3};
    }

    public long[] getMinLocation() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        long l = 0L;
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            int n5;
            n4 = Math.min(n4, this.slices);
            Future[] futureArray = new Future[n4];
            long[][] lArray = new long[n4][2];
            int n6 = this.slices / n4;
            for (n5 = 0; n5 < n4; ++n5) {
                final int n7 = n5 * n6;
                final int n8 = n5 == n4 - 1 ? this.slices : n7 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Callable<long[]>(){

                    @Override
                    public long[] call() throws Exception {
                        int n = n7;
                        int n2 = 0;
                        int n3 = 0;
                        long l = LongMatrix3D.this.getQuick(n, 0, 0);
                        int n4 = 1;
                        for (int i = n7; i < n8; ++i) {
                            for (int j = 0; j < LongMatrix3D.this.rows; ++j) {
                                for (int k = n4; k < LongMatrix3D.this.columns; ++k) {
                                    long l2 = LongMatrix3D.this.getQuick(i, j, k);
                                    if (l <= l2) continue;
                                    l = l2;
                                    n = i;
                                    n2 = j;
                                    n3 = k;
                                }
                                n4 = 0;
                            }
                        }
                        return new long[]{l, n, n2, n3};
                    }
                });
            }
            try {
                for (n5 = 0; n5 < n4; ++n5) {
                    lArray[n5] = (long[])futureArray[n5].get();
                }
                l = lArray[0][0];
                n = (int)lArray[0][1];
                n2 = (int)lArray[0][2];
                n3 = (int)lArray[0][3];
                for (n5 = 1; n5 < n4; ++n5) {
                    if (l <= lArray[n5][0]) continue;
                    l = lArray[n5][0];
                    n = (int)lArray[n5][1];
                    n2 = (int)lArray[n5][2];
                    n3 = (int)lArray[n5][3];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            l = this.getQuick(0, 0, 0);
            int n9 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n9; k < this.columns; ++k) {
                        long l2 = this.getQuick(i, j, k);
                        if (l <= l2) continue;
                        l = l2;
                        n = i;
                        n2 = j;
                        n3 = k;
                    }
                    n9 = 0;
                }
            }
        }
        return new long[]{l, n, n2, n3};
    }

    public void set(int n, int n2, int n3, long l) {
        if (n < 0 || n >= this.slices || n2 < 0 || n2 >= this.rows || n3 < 0 || n3 >= this.columns) {
            throw new IndexOutOfBoundsException("slice:" + n + ", row:" + n2 + ", column:" + n3);
        }
        this.setQuick(n, n2, n3, l);
    }

    public abstract void setQuick(int var1, int var2, int var3, long var4);

    public long[][][] toArray() {
        final long[][][] lArray = new long[this.slices][this.rows][this.columns];
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            long[][] lArray3 = lArray[i];
                            for (int j = 0; j < LongMatrix3D.this.rows; ++j) {
                                long[] lArray2 = lArray3[j];
                                for (int k = 0; k < LongMatrix3D.this.columns; ++k) {
                                    lArray2[k] = LongMatrix3D.this.getQuick(i, j, k);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                long[][] lArray2 = lArray[i];
                for (int j = 0; j < this.rows; ++j) {
                    long[] lArray3 = lArray2[j];
                    for (int k = 0; k < this.columns; ++k) {
                        lArray3[k] = this.getQuick(i, j, k);
                    }
                }
            }
        }
        return lArray;
    }

    public String toString() {
        return new LongFormatter().toString(this);
    }

    public abstract LongMatrix1D vectorize();

    protected LongMatrix3D view() {
        return (LongMatrix3D)this.clone();
    }

    public LongMatrix2D viewColumn(int n) {
        this.checkColumn(n);
        int n2 = this.slices;
        int n3 = this.rows;
        int n4 = this.sliceZero;
        int n5 = this.rowZero + this._columnOffset(this._columnRank(n));
        int n6 = this.sliceStride;
        int n7 = this.rowStride;
        return this.like2D(n2, n3, n4, n5, n6, n7);
    }

    public LongMatrix3D viewColumnFlip() {
        return (LongMatrix3D)this.view().vColumnFlip();
    }

    public LongMatrix3D viewDice(int n, int n2, int n3) {
        return (LongMatrix3D)this.view().vDice(n, n2, n3);
    }

    public LongMatrix3D viewPart(int n, int n2, int n3, int n4, int n5, int n6) {
        return (LongMatrix3D)this.view().vPart(n, n2, n3, n4, n5, n6);
    }

    public LongMatrix2D viewRow(int n) {
        this.checkRow(n);
        int n2 = this.slices;
        int n3 = this.columns;
        int n4 = this.sliceZero;
        int n5 = this.columnZero + this._rowOffset(this._rowRank(n));
        int n6 = this.sliceStride;
        int n7 = this.columnStride;
        return this.like2D(n2, n3, n4, n5, n6, n7);
    }

    public LongMatrix3D viewRowFlip() {
        return (LongMatrix3D)this.view().vRowFlip();
    }

    public LongMatrix3D viewSelection(LongMatrix2DProcedure longMatrix2DProcedure) {
        IntArrayList intArrayList = new IntArrayList();
        for (int i = 0; i < this.slices; ++i) {
            if (!longMatrix2DProcedure.apply(this.viewSlice(i))) continue;
            intArrayList.add(i);
        }
        intArrayList.trimToSize();
        return this.viewSelection(intArrayList.elements(), null, null);
    }

    public LongMatrix3D viewSelection(int[] nArray, int[] nArray2, int[] nArray3) {
        int n;
        int n2;
        if (nArray == null) {
            nArray = new int[this.slices];
            for (n2 = 0; n2 < this.slices; ++n2) {
                nArray[n2] = n2;
            }
        }
        if (nArray2 == null) {
            nArray2 = new int[this.rows];
            for (n2 = 0; n2 < this.rows; ++n2) {
                nArray2[n2] = n2;
            }
        }
        if (nArray3 == null) {
            nArray3 = new int[this.columns];
            for (n2 = 0; n2 < this.columns; ++n2) {
                nArray3[n2] = n2;
            }
        }
        this.checkSliceIndexes(nArray);
        this.checkRowIndexes(nArray2);
        this.checkColumnIndexes(nArray3);
        int[] nArray4 = new int[nArray.length];
        int[] nArray5 = new int[nArray2.length];
        int[] nArray6 = new int[nArray3.length];
        for (n = 0; n < nArray.length; ++n) {
            nArray4[n] = this._sliceOffset(this._sliceRank(nArray[n]));
        }
        for (n = 0; n < nArray2.length; ++n) {
            nArray5[n] = this._rowOffset(this._rowRank(nArray2[n]));
        }
        for (n = 0; n < nArray3.length; ++n) {
            nArray6[n] = this._columnOffset(this._columnRank(nArray3[n]));
        }
        return this.viewSelectionLike(nArray4, nArray5, nArray6);
    }

    protected abstract LongMatrix3D viewSelectionLike(int[] var1, int[] var2, int[] var3);

    public LongMatrix2D viewSlice(int n) {
        this.checkSlice(n);
        int n2 = this.rows;
        int n3 = this.columns;
        int n4 = this.rowZero;
        int n5 = this.columnZero + this._sliceOffset(this._sliceRank(n));
        int n6 = this.rowStride;
        int n7 = this.columnStride;
        return this.like2D(n2, n3, n4, n5, n6, n7);
    }

    public LongMatrix3D viewSliceFlip() {
        return (LongMatrix3D)this.view().vSliceFlip();
    }

    public LongMatrix3D viewSorted(int n, int n2) {
        return LongSorting.mergeSort.sort(this, n, n2);
    }

    public LongMatrix3D viewStrides(int n, int n2, int n3) {
        return (LongMatrix3D)this.view().vStrides(n, n2, n3);
    }

    public long zSum() {
        if (this.size() == 0L) {
            return 0L;
        }
        return this.aggregate(LongFunctions.plus, LongFunctions.identity);
    }
}

