/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.SingularValueDecomposition;
import dr.inference.model.MatrixParameter;
import dr.inference.model.Parameter;
import dr.inference.operators.AbstractAdaptableOperator;
import dr.inference.operators.AdaptationMode;
import dr.inference.operators.MCMCOperator;
import dr.math.MathUtils;
import dr.math.matrixAlgebra.CholeskyDecomposition;
import dr.math.matrixAlgebra.IllegalDimension;
import dr.math.matrixAlgebra.SymmetricMatrix;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class MultivariateNormalOperator
extends AbstractAdaptableOperator {
    public static final String MVN_OPERATOR = "mvnOperator";
    public static final String SCALE_FACTOR = "scaleFactor";
    public static final String VARIANCE_MATRIX = "varMatrix";
    public static final String FORM_XTX = "formXtXInverse";
    private double scaleFactor;
    private final Parameter parameter;
    private final int dim;
    private double[][] cholesky;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("scaleFactor"), AttributeRule.newDoubleRule("weight"), AttributeRule.newBooleanRule("autoOptimize", true), AttributeRule.newBooleanRule("formXtXInverse", true), new ElementRule(Parameter.class), new ElementRule("varMatrix", new XMLSyntaxRule[]{new ElementRule(MatrixParameter.class)})};

        @Override
        public String getParserName() {
            return MultivariateNormalOperator.MVN_OPERATOR;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            AdaptationMode adaptationMode = AdaptationMode.parseMode(xMLObject);
            double d = xMLObject.getDoubleAttribute("weight");
            double d2 = xMLObject.getDoubleAttribute(MultivariateNormalOperator.SCALE_FACTOR);
            if (d2 <= 0.0) {
                throw new XMLParseException("scaleFactor must be greater than 0.0");
            }
            Parameter parameter = (Parameter)xMLObject.getChild(Parameter.class);
            boolean bl = xMLObject.getAttribute(MultivariateNormalOperator.FORM_XTX, false);
            XMLObject xMLObject2 = xMLObject.getChild(MultivariateNormalOperator.VARIANCE_MATRIX);
            MatrixParameter matrixParameter = (MatrixParameter)xMLObject2.getChild(MatrixParameter.class);
            if (!bl && matrixParameter.getColumnDimension() != matrixParameter.getRowDimension()) {
                throw new XMLParseException("The variance matrix is not square");
            }
            if (matrixParameter.getColumnDimension() != parameter.getDimension()) {
                throw new XMLParseException("The parameter and variance matrix have differing dimensions");
            }
            return new MultivariateNormalOperator(parameter, d2, matrixParameter, d, adaptationMode, !bl);
        }

        @Override
        public String getParserDescription() {
            return "This element returns a multivariate normal random walk operator on a given parameter.";
        }

        @Override
        public Class getReturnType() {
            return MCMCOperator.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public MultivariateNormalOperator(Parameter parameter, double d, double[][] dArray, double d2, AdaptationMode adaptationMode, boolean bl) {
        super(adaptationMode);
        this.scaleFactor = d;
        this.parameter = parameter;
        this.setWeight(d2);
        this.dim = parameter.getDimension();
        SingularValueDecomposition singularValueDecomposition = new SingularValueDecomposition(new DenseDoubleMatrix2D(dArray));
        if (dArray[0].length != singularValueDecomposition.rank()) {
            throw new RuntimeException("Variance matrix in mvnOperator is not of full rank");
        }
        double[][] dArray2 = bl ? dArray : this.formXtXInverse(dArray);
        try {
            this.cholesky = new CholeskyDecomposition(dArray2).getL();
        }
        catch (IllegalDimension illegalDimension) {
            throw new RuntimeException("Unable to decompose matrix in mvnOperator");
        }
    }

    public MultivariateNormalOperator(Parameter parameter, double d, MatrixParameter matrixParameter, double d2, AdaptationMode adaptationMode, boolean bl) {
        this(parameter, d, matrixParameter.getParameterAsMatrix(), d2, adaptationMode, bl);
    }

    private double[][] formXtXInverse(double[][] dArray) {
        int n;
        int n2 = dArray.length;
        int n3 = dArray[0].length;
        double[][] dArray2 = new double[n3][n3];
        for (int i = 0; i < n3; ++i) {
            for (n = i; n < n3; ++n) {
                double d = 0.0;
                for (int j = 0; j < n2; ++j) {
                    d += dArray[j][i] * dArray[j][n];
                }
                double d2 = d;
                dArray2[i][n] = d2;
                dArray2[n][i] = d2;
            }
        }
        double[][] dArray3 = new SymmetricMatrix(dArray2).inverse().toComponents();
        for (n = 0; n < dArray3.length; ++n) {
            for (int i = n; i < dArray3[n].length; ++i) {
                double d = (dArray3[i][n] + dArray3[n][i]) / 2.0;
                dArray3[n][i] = d;
                dArray3[i][n] = d;
            }
        }
        return dArray3;
    }

    @Override
    public double doOperation() {
        int n;
        double[] dArray = this.parameter.getParameterValues();
        double[] dArray2 = new double[this.dim];
        for (n = 0; n < this.dim; ++n) {
            dArray2[n] = this.scaleFactor * MathUtils.nextGaussian();
        }
        for (n = 0; n < this.dim; ++n) {
            for (int i = n; i < this.dim; ++i) {
                int n2 = n;
                dArray[n2] = dArray[n2] + this.cholesky[i][n] * dArray2[i];
            }
            this.parameter.setParameterValueQuietly(n, dArray[n]);
        }
        this.parameter.fireParameterChangedEvent();
        return 0.0;
    }

    @Override
    public final String getOperatorName() {
        return this.parameter.getParameterName();
    }

    @Override
    protected double getAdaptableParameterValue() {
        return Math.log(this.scaleFactor);
    }

    @Override
    public void setAdaptableParameterValue(double d) {
        this.scaleFactor = Math.exp(d);
    }

    @Override
    public double getRawParameter() {
        return this.scaleFactor;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    @Override
    public String getAdaptableParameterName() {
        return SCALE_FACTOR;
    }
}

