/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evolution.tree.TreeTraitProvider;
import dr.evomodel.branchratemodel.BranchRateModel;
import dr.evomodel.treedatalikelihood.SimulationTreeTraversal;
import dr.evomodel.treedatalikelihood.TreeDataLikelihood;
import dr.evomodel.treedatalikelihood.preorder.ProcessSimulationDelegate;
import dr.inference.model.Model;
import dr.inference.model.ModelListener;

public class ProcessSimulation
implements ModelListener,
TreeTraitProvider {
    private final Tree tree;
    private final SimulationTreeTraversal treeTraversalDelegate;
    private final TreeDataLikelihood treeDataLikelihood;
    private final ProcessSimulationDelegate simulationDelegate;
    private final int[] operations;
    private boolean validSimulation;
    private static final boolean IGNORE_REMAINDER = true;

    public ProcessSimulation(TreeDataLikelihood treeDataLikelihood, ProcessSimulationDelegate processSimulationDelegate) {
        this.treeDataLikelihood = treeDataLikelihood;
        this.tree = treeDataLikelihood.getTree();
        BranchRateModel branchRateModel = treeDataLikelihood.getBranchRateModel();
        this.treeTraversalDelegate = new SimulationTreeTraversal(this.tree, branchRateModel, processSimulationDelegate.getOptimalTraversalType());
        treeDataLikelihood.addModelListener(this);
        treeDataLikelihood.addModelRestoreListener(this);
        this.simulationDelegate = processSimulationDelegate;
        processSimulationDelegate.setCallback(this);
        this.operations = new int[this.tree.getNodeCount() * processSimulationDelegate.getSingleOperationSize()];
        this.validSimulation = false;
    }

    public final void cacheSimulatedTraits(NodeRef nodeRef) {
        if (!this.validSimulation) {
            this.treeDataLikelihood.calculatePostOrderStatistics();
            this.simulateTraits(nodeRef);
            this.validSimulation = true;
        }
    }

    private void simulateTraits(NodeRef nodeRef) {
        if (nodeRef == null) {
            this.treeTraversalDelegate.updateAllNodes();
        } else {
            this.treeTraversalDelegate.updateAllNodes();
        }
        this.treeTraversalDelegate.dispatchTreeTraversalCollectBranchAndNodeOperations();
        int n = this.simulationDelegate.vectorizeNodeOperations(this.treeTraversalDelegate.getNodeOperations(), this.operations);
        NodeRef nodeRef2 = this.tree.getRoot();
        this.simulationDelegate.simulate(this.operations, n, nodeRef2.getNumber());
        this.treeTraversalDelegate.setAllNodesUpdated();
    }

    @Override
    public TreeTrait[] getTreeTraits() {
        return this.simulationDelegate.getTreeTraits();
    }

    @Override
    public TreeTrait getTreeTrait(String string) {
        return this.simulationDelegate.getTreeTrait(string);
    }

    @Override
    public void modelChangedEvent(Model model, Object object, int n) {
        assert (model == this.treeDataLikelihood) : "Invalid model";
        this.validSimulation = false;
    }

    @Override
    public void modelRestored(Model model) {
        this.validSimulation = false;
    }
}

