/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent.demographicmodel;

import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.coalescent.ExpConstant;
import dr.evolution.util.Units;
import dr.evomodel.coalescent.demographicmodel.DemographicModel;
import dr.inference.model.Parameter;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import java.util.Collections;
import java.util.List;

public class ExponentialConstantModel
extends DemographicModel
implements Citable {
    Parameter N0Parameter = null;
    Parameter growthRateParameter = null;
    Parameter transitionTimeParameter = null;
    ExpConstant exponentialConstant = null;
    public static Citation CITATION = new Citation(new Author[]{new Author("OG", "Pybus"), new Author("A", "Rambaut")}, "GENIE: estimating demographic history from molecular phylogenies", 2001, "Bioinformatics", 18, 1404, 1405);

    public ExponentialConstantModel(Parameter parameter, Parameter parameter2, Parameter parameter3, Units.Type type) {
        this("exponentialConstant", parameter, parameter2, parameter3, type);
    }

    public ExponentialConstantModel(String string, Parameter parameter, Parameter parameter2, Parameter parameter3, Units.Type type) {
        super(string);
        this.exponentialConstant = new ExpConstant(type);
        this.N0Parameter = parameter;
        this.addVariable(parameter);
        parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.growthRateParameter = parameter2;
        this.addVariable(parameter2);
        parameter2.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.transitionTimeParameter = parameter3;
        this.addVariable(parameter3);
        parameter3.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 1));
        this.setUnits(type);
    }

    @Override
    public DemographicFunction getDemographicFunction() {
        this.exponentialConstant.setN0(this.N0Parameter.getParameterValue(0));
        this.exponentialConstant.setGrowthRate(this.growthRateParameter.getParameterValue(0));
        this.exponentialConstant.setTransitionTime(this.transitionTimeParameter.getParameterValue(0) - this.getTimeOffset());
        return this.exponentialConstant;
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.TREE_PRIORS;
    }

    @Override
    public String getDescription() {
        return "Exponential-Constant Coalescent";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CITATION);
    }
}

