/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.reified.leaves.bool;

import choco.cp.solver.constraints.integer.bool.BooleanFactory;
import choco.cp.solver.constraints.integer.channeling.ReifiedLargeNand;
import choco.cp.solver.constraints.reified.leaves.bool.AbstractBoolNode;
import choco.kernel.common.util.tools.ArrayUtils;
import choco.kernel.common.util.tools.StringUtils;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.constraints.reified.BoolNode;
import choco.kernel.solver.constraints.reified.INode;
import choco.kernel.solver.constraints.reified.NodeType;
import choco.kernel.solver.variables.integer.IntDomainVar;

public class NandNode
extends AbstractBoolNode {
    public NandNode(INode ... subt) {
        super(subt, NodeType.NAND);
    }

    @Override
    public boolean checkTuple(int[] tuple) {
        for (INode subtree : this.subtrees) {
            if (((BoolNode)((Object)subtree)).checkTuple(tuple)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IntDomainVar extractResult(Solver s) {
        IntDomainVar[] vs = new IntDomainVar[this.subtrees.length + 1];
        for (int i = 0; i < vs.length; ++i) {
            vs[i] = this.subtrees[i].extractResult(s);
        }
        IntDomainVar v = s.createBooleanVar(StringUtils.randomName());
        s.post(new ReifiedLargeNand(ArrayUtils.append({v}, vs), s.getEnvironment()));
        return v;
    }

    @Override
    public SConstraint extractConstraint(Solver s) {
        IntDomainVar[] vs = new IntDomainVar[this.subtrees.length];
        for (int i = 0; i < vs.length; ++i) {
            vs[i] = this.subtrees[i].extractResult(s);
        }
        return BooleanFactory.nand(s.getEnvironment(), vs);
    }

    @Override
    public boolean isReified() {
        return true;
    }

    @Override
    public String pretty() {
        int i;
        StringBuilder st = new StringBuilder("(");
        for (i = 0; i < this.subtrees.length - 1; ++i) {
            st.append(this.subtrees[i].pretty()).append(" nand ");
        }
        st.append(this.subtrees[i].pretty()).append(')');
        return st.toString();
    }
}

