/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong.impl;

import cern.colt.matrix.tlong.LongMatrix1D;
import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.LongMatrix3D;

public class WrapperLongMatrix1D
extends LongMatrix1D {
    private static final long serialVersionUID = 1L;
    protected LongMatrix1D content;

    public WrapperLongMatrix1D(LongMatrix1D longMatrix1D) {
        if (longMatrix1D != null) {
            this.setUp((int)longMatrix1D.size());
        }
        this.content = longMatrix1D;
    }

    protected LongMatrix1D getContent() {
        return this.content;
    }

    public synchronized long getQuick(int n) {
        return this.content.getQuick(n);
    }

    public Object elements() {
        return this.content.elements();
    }

    public LongMatrix1D like(int n) {
        return this.content.like(n);
    }

    public LongMatrix2D like2D(int n, int n2) {
        return this.content.like2D(n, n2);
    }

    public LongMatrix2D reshape(int n, int n2) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public LongMatrix3D reshape(int n, int n2, int n3) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public synchronized void setQuick(int n, long l) {
        this.content.setQuick(n, l);
    }

    public LongMatrix1D viewFlip() {
        WrapperLongMatrix1D wrapperLongMatrix1D = new WrapperLongMatrix1D(this){
            private static final long serialVersionUID = 1L;

            public synchronized long getQuick(int n) {
                return this.content.getQuick(this.size - 1 - n);
            }

            public synchronized void setQuick(int n, long l) {
                this.content.setQuick(this.size - 1 - n, l);
            }

            public synchronized long get(int n) {
                return this.content.get(this.size - 1 - n);
            }

            public synchronized void set(int n, long l) {
                this.content.set(this.size - 1 - n, l);
            }
        };
        return wrapperLongMatrix1D;
    }

    public LongMatrix1D viewPart(final int n, int n2) {
        this.checkRange(n, n2);
        WrapperLongMatrix1D wrapperLongMatrix1D = new WrapperLongMatrix1D(this){
            private static final long serialVersionUID = 1L;

            public synchronized long getQuick(int n2) {
                return this.content.getQuick(n + n2);
            }

            public synchronized void setQuick(int n2, long l) {
                this.content.setQuick(n + n2, l);
            }

            public synchronized long get(int n2) {
                return this.content.get(n + n2);
            }

            public synchronized void set(int n2, long l) {
                this.content.set(n + n2, l);
            }
        };
        wrapperLongMatrix1D.setSize(n2);
        return wrapperLongMatrix1D;
    }

    public LongMatrix1D viewSelection(int[] nArray) {
        if (nArray == null) {
            nArray = new int[this.size];
            int n = this.size;
            while (--n >= 0) {
                nArray[n] = n;
            }
        }
        this.checkIndexes(nArray);
        final int[] nArray2 = nArray;
        WrapperLongMatrix1D wrapperLongMatrix1D = new WrapperLongMatrix1D(this){
            private static final long serialVersionUID = 1L;

            public synchronized long getQuick(int n) {
                return this.content.getQuick(nArray2[n]);
            }

            public synchronized void setQuick(int n, long l) {
                this.content.setQuick(nArray2[n], l);
            }

            public synchronized long get(int n) {
                return this.content.get(nArray2[n]);
            }

            public synchronized void set(int n, long l) {
                this.content.set(nArray2[n], l);
            }
        };
        wrapperLongMatrix1D.setSize(nArray.length);
        return wrapperLongMatrix1D;
    }

    protected LongMatrix1D viewSelectionLike(int[] nArray) {
        throw new InternalError();
    }

    public LongMatrix1D viewStrides(final int n) {
        if (this.stride <= 0) {
            throw new IndexOutOfBoundsException("illegal stride: " + this.stride);
        }
        WrapperLongMatrix1D wrapperLongMatrix1D = new WrapperLongMatrix1D(this){
            private static final long serialVersionUID = 1L;

            public synchronized long getQuick(int n2) {
                return this.content.getQuick(n2 * n);
            }

            public synchronized void setQuick(int n2, long l) {
                this.content.setQuick(n2 * n, l);
            }

            public synchronized long get(int n2) {
                return this.content.get(n2 * n);
            }

            public synchronized void set(int n2, long l) {
                this.content.set(n2 * n, l);
            }
        };
        wrapperLongMatrix1D.setSize(this.size);
        if (this.size != 0) {
            wrapperLongMatrix1D.setSize((this.size - 1) / n + 1);
        }
        return wrapperLongMatrix1D;
    }
}

