/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.decomposition;

import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DenseDoubleAlgebra;
import cern.colt.matrix.tdouble.algo.DoubleProperty;
import cern.colt.matrix.tdouble.algo.decomposition.DenseDoubleSingularValueDecomposition;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.jet.math.tdouble.DoubleFunctions;
import java.util.Random;

public class TestDenseDoubleSVD {
    public static void main(String[] stringArray) {
        int n;
        int n2;
        int n3 = 60;
        int n4 = 40;
        int n5 = 1;
        Random random = new Random(0L);
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(n3, n4);
        DenseDoubleMatrix2D denseDoubleMatrix2D2 = new DenseDoubleMatrix2D(n3, n4);
        DenseDoubleMatrix2D denseDoubleMatrix2D3 = new DenseDoubleMatrix2D(n3, n5);
        DenseDoubleMatrix2D denseDoubleMatrix2D4 = new DenseDoubleMatrix2D(n3, n5);
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n4; ++n) {
                ((DoubleMatrix2D)denseDoubleMatrix2D).setQuick(n2, n, 0.5 - random.nextDouble());
                ((DoubleMatrix2D)denseDoubleMatrix2D2).setQuick(n2, n, ((DoubleMatrix2D)denseDoubleMatrix2D).getQuick(n2, n));
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n5; ++n) {
                ((DoubleMatrix2D)denseDoubleMatrix2D3).setQuick(n2, n, 0.5 - random.nextDouble());
                ((DoubleMatrix2D)denseDoubleMatrix2D4).setQuick(n2, n, ((DoubleMatrix2D)denseDoubleMatrix2D3).getQuick(n2, n));
            }
        }
        TestDenseDoubleSVD.testSVD(denseDoubleMatrix2D, denseDoubleMatrix2D2, denseDoubleMatrix2D3, denseDoubleMatrix2D4);
    }

    private static void testSVD(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2, DoubleMatrix2D doubleMatrix2D3, DoubleMatrix2D doubleMatrix2D4) {
        int n = doubleMatrix2D.rows();
        int n2 = doubleMatrix2D.columns();
        double d = 1.0E-10;
        DenseDoubleSingularValueDecomposition denseDoubleSingularValueDecomposition = new DenseDoubleSingularValueDecomposition(doubleMatrix2D2, true, false);
        DoubleMatrix2D doubleMatrix2D5 = denseDoubleSingularValueDecomposition.getS();
        DoubleMatrix2D doubleMatrix2D6 = denseDoubleSingularValueDecomposition.getV();
        DoubleMatrix2D doubleMatrix2D7 = denseDoubleSingularValueDecomposition.getU();
        System.out.println(denseDoubleSingularValueDecomposition.toString());
        System.out.print("\n");
        System.out.print("------ DenseDoubleSingularValueDecomposition tests-------  \n");
        System.out.print(String.format("            Size of the Matrix %d by %d\n", n, n2));
        System.out.print("\n");
        System.out.print(" The matrix A is randomly generated for each test.\n");
        System.out.print("============\n");
        System.out.print(String.format(" The relative machine precision (eps) is to be %e \n", d));
        System.out.print(" Computational tests pass if scaled residuals are less than 10.\n");
        int n3 = TestDenseDoubleSVD.checkFactorization(doubleMatrix2D, doubleMatrix2D7, doubleMatrix2D5, doubleMatrix2D6, d);
        if (n3 == 0) {
            System.out.print("************************************************\n");
            System.out.print(" ---- TESTING DenseDoubleSingularValueDecomposition .... PASSED !\n");
            System.out.print("************************************************\n");
        } else {
            System.out.print("************************************************\n");
            System.out.print(" ---- TESTING DenseDoubleSingularValueDecomposition .... FAILED !\n");
            System.out.print("************************************************\n");
        }
    }

    private static int checkFactorization(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2, DoubleMatrix2D doubleMatrix2D3, DoubleMatrix2D doubleMatrix2D4, double d) {
        int n;
        DoubleProperty.DEFAULT.checkDense(doubleMatrix2D);
        DoubleProperty.DEFAULT.checkDense(doubleMatrix2D2);
        DoubleProperty.DEFAULT.checkDense(doubleMatrix2D4);
        int n2 = doubleMatrix2D.rows();
        int n3 = doubleMatrix2D.columns();
        DoubleMatrix2D doubleMatrix2D5 = doubleMatrix2D2.copy();
        double d2 = 1.0;
        DoubleMatrix2D doubleMatrix2D6 = doubleMatrix2D.copy();
        doubleMatrix2D5 = doubleMatrix2D5.zMult(doubleMatrix2D3, null, d2, 0.0, false, false);
        doubleMatrix2D5 = doubleMatrix2D5.zMult(doubleMatrix2D4, null, d2, 0.0, false, true);
        doubleMatrix2D6.assign(doubleMatrix2D5, DoubleFunctions.plusMultFirst(-1.0));
        double d3 = DenseDoubleAlgebra.DEFAULT.normInfinity(doubleMatrix2D6);
        double d4 = DenseDoubleAlgebra.DEFAULT.normInfinity(doubleMatrix2D);
        System.out.print("============\n");
        System.out.print("Checking the SVD Factorization \n");
        System.out.print(String.format("-- ||USV'-A||_oo/(||A||_oo.N.eps) = %e \n", d3 / (d4 * (double)n3 * d)));
        if (d3 / (d4 * (double)n3 * d) > 10.0) {
            System.out.print("-- Factorization is suspicious ! \n");
            n = 1;
        } else {
            System.out.print("-- Factorization is CORRECT ! \n");
            n = 0;
        }
        return n;
    }
}

