/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.distribution.DistributionLikelihood;
import dr.inference.distribution.GammaDistributionModel;
import dr.inference.distribution.LinearRegression;
import dr.inference.model.Parameter;
import dr.inference.operators.GibbsOperator;
import dr.inference.operators.MCMCOperator;
import dr.inference.operators.NormalGammaPrecisionGibbsOperator;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import dr.math.distributions.Distribution;
import dr.math.distributions.GammaDistribution;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class RegressionGibbsPrecisionOperator
extends SimpleMCMCOperator
implements GibbsOperator {
    public static final String GIBBS_OPERATOR = "regressionGibbsPrecisionOperator";
    private LinearRegression linearModel;
    private Parameter precision;
    private int dim;
    private int N;
    private int[] scaleDesign;
    private Distribution prior;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("weight"), new ElementRule(Parameter.class), new ElementRule(DistributionLikelihood.class), new ElementRule(LinearRegression.class)};

        @Override
        public String getParserName() {
            return RegressionGibbsPrecisionOperator.GIBBS_OPERATOR;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            double d = xMLObject.getDoubleAttribute("weight");
            LinearRegression linearRegression = (LinearRegression)xMLObject.getChild(LinearRegression.class);
            Parameter parameter = (Parameter)xMLObject.getChild(Parameter.class);
            DistributionLikelihood distributionLikelihood = (DistributionLikelihood)xMLObject.getChild(DistributionLikelihood.class);
            if (!(distributionLikelihood.getDistribution() instanceof GammaDistribution) && !(distributionLikelihood.getDistribution() instanceof GammaDistributionModel)) {
                throw new XMLParseException("Gibbs operator assumes normal-gamma model");
            }
            RegressionGibbsPrecisionOperator regressionGibbsPrecisionOperator = new RegressionGibbsPrecisionOperator(linearRegression, parameter, distributionLikelihood.getDistribution());
            regressionGibbsPrecisionOperator.setWeight(d);
            return regressionGibbsPrecisionOperator;
        }

        @Override
        public String getParserDescription() {
            return "This element returns a multivariate Gibbs operator on an internal node trait.";
        }

        @Override
        public Class getReturnType() {
            return MCMCOperator.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public RegressionGibbsPrecisionOperator(LinearRegression linearRegression, Parameter parameter, Distribution distribution) {
        if (!(distribution instanceof GammaDistribution) && !(distribution instanceof GammaDistributionModel)) {
            throw new RuntimeException("Precision prior must be Gamma");
        }
        this.prior = distribution;
        this.linearModel = linearRegression;
        this.precision = parameter;
        this.dim = parameter.getDimension();
        this.scaleDesign = linearRegression.getScaleDesign();
        this.N = linearRegression.getDependentVariable().getDimension();
    }

    public int getStepCount() {
        return 1;
    }

    @Override
    public double doOperation() {
        double[] dArray = this.linearModel.getTransformedDependentParameter();
        double[] dArray2 = this.linearModel.getXBeta();
        NormalGammaPrecisionGibbsOperator.GammaParametrization gammaParametrization = new NormalGammaPrecisionGibbsOperator.GammaParametrization(this.prior.mean(), this.prior.variance());
        for (int i = 0; i < this.dim; ++i) {
            double d = 0.0;
            int n = 0;
            for (int j = 0; j < this.N; ++j) {
                if (this.scaleDesign[j] != i) continue;
                d += (dArray[j] - dArray2[j]) * (dArray[j] - dArray2[j]);
                ++n;
            }
            double d2 = gammaParametrization.getShape(i) + (double)n / 2.0;
            double d3 = gammaParametrization.getRate(i) + 0.5 * d;
            double d4 = MathUtils.nextGamma(d2, d3);
            this.precision.setParameterValue(i, d4);
        }
        return 0.0;
    }

    public String getPerformanceSuggestion() {
        return null;
    }

    @Override
    public String getOperatorName() {
        return GIBBS_OPERATOR;
    }
}

