/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.parsimony;

import dr.evolution.alignment.PatternList;
import dr.evolution.tree.MutableTree;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;

public class Parsimony {
    public static int getParsimonySteps(Tree tree, PatternList patternList) {
        int[] nArray = new int[]{0};
        for (int i = 0; i < patternList.getPatternCount(); ++i) {
            String string = "state" + String.valueOf(i + 1);
            Parsimony.getParsimonyState(tree, tree.getRoot(), patternList, i, string, nArray);
        }
        return nArray[0];
    }

    public static void reconstructParsimonyStates(Tree tree, PatternList patternList) {
        for (int i = 0; i < patternList.getPatternCount(); ++i) {
            String string = "state" + String.valueOf(i + 1);
            int[] nArray = Parsimony.getParsimonyState2(tree, tree.getRoot(), patternList, i, string, patternList.getDataType().getStateCount());
            int n = 0;
            int n2 = nArray[0];
            for (int j = 1; j < nArray.length; ++j) {
                if (nArray[j] >= n2) continue;
                n2 = nArray[j];
                n = i;
            }
            Parsimony.reconstructParsimonyState2(tree, tree.getRoot(), string, "r" + string, n);
        }
    }

    private static void reconstructParsimonyState2(Tree tree, NodeRef nodeRef, String string, String string2, int n) {
        int n2;
        int n3;
        int n4;
        if (tree.isRoot(nodeRef)) {
            int[] nArray = (int[])tree.getNodeAttribute(nodeRef, string);
            n4 = 0;
            int n5 = nArray[0];
            for (n3 = 1; n3 < nArray.length; ++n3) {
                if (nArray[n3] >= n5) continue;
                n5 = nArray[n3];
                n4 = n3;
            }
            n = n4;
        }
        if ((n2 = tree.getChildCount(nodeRef)) > 0) {
            int n6;
            n4 = 0;
            int[][] nArrayArray = new int[n2][];
            for (n3 = 0; n3 < n2; ++n3) {
                nArrayArray[n3] = (int[])tree.getNodeAttribute(tree.getChild(nodeRef, n3), string);
            }
            int[] nArray = new int[n2];
            int[] nArray2 = new int[n2];
            int n7 = nArrayArray[0].length;
            int n8 = (int)Math.round(Math.pow(n7, n2));
            for (n6 = 0; n6 < n8; ++n6) {
                int n9;
                int n10;
                int n11 = n6;
                for (n10 = 0; n10 < n2; ++n10) {
                    nArray[n10] = n11 % n7;
                    n11 /= n7;
                }
                n10 = 0;
                for (n9 = 0; n9 < n2; ++n9) {
                    n10 += nArrayArray[n9][nArray[n9]] + Parsimony.penalty(n, nArray[n9]);
                }
                if (n6 == 0) {
                    n4 = n10;
                    continue;
                }
                if (n10 >= n4) continue;
                n4 = n10;
                for (n9 = 0; n9 < n2; ++n9) {
                    nArray2[n9] = nArray[n9];
                }
            }
            for (n6 = 0; n6 < n2; ++n6) {
                Parsimony.reconstructParsimonyState2(tree, tree.getChild(nodeRef, n6), string, string2, nArray2[n6]);
            }
        }
        ((MutableTree)tree).setNodeAttribute(nodeRef, string2, new Integer(n));
    }

    private static int[] getParsimonyState2(Tree tree, NodeRef nodeRef, PatternList patternList, int n, String string, int n2) {
        if (tree.isExternal(nodeRef)) {
            int n3 = patternList.getPatternState(patternList.getTaxonIndex(tree.getNodeTaxon(nodeRef).getId()), n);
            int[] nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = 0x6666666;
            }
            if (n3 < n2) {
                nArray[n3] = 0;
            } else {
                nArray[n2 - 1] = 0;
            }
            ((MutableTree)tree).setNodeAttribute(nodeRef, string, nArray);
            return nArray;
        }
        int n4 = tree.getChildCount(nodeRef);
        int[][] nArrayArray = new int[n4][];
        for (int i = 0; i < n4; ++i) {
            nArrayArray[i] = Parsimony.getParsimonyState2(tree, tree.getChild(nodeRef, i), patternList, n, string, n2);
        }
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            int[] nArray2 = new int[n4];
            int n5 = (int)Math.round(Math.pow(n2, n4));
            for (int j = 0; j < n5; ++j) {
                int n6;
                int n7 = j;
                for (n6 = 0; n6 < n4; ++n6) {
                    nArray2[n6] = n7 % n2;
                    n7 /= n2;
                }
                n6 = 0;
                for (int k = 0; k < n4; ++k) {
                    n6 += nArrayArray[k][nArray2[k]] + Parsimony.penalty(i, nArray2[k]);
                }
                if (j == 0) {
                    nArray[i] = n6;
                    continue;
                }
                if (n6 >= nArray[i]) continue;
                nArray[i] = n6;
            }
        }
        ((MutableTree)tree).setNodeAttribute(nodeRef, string, nArray);
        return nArray;
    }

    private static final int penalty(int n, int n2) {
        if (n == n2) {
            return 0;
        }
        return 1;
    }

    private static boolean[] getParsimonyState(Tree tree, NodeRef nodeRef, PatternList patternList, int n, String string, int[] nArray) {
        int n2;
        if (tree.isExternal(nodeRef)) {
            int n3 = patternList.getPatternState(patternList.getTaxonIndex(tree.getNodeTaxon(nodeRef).getId()), n);
            ((MutableTree)tree).setNodeAttribute(nodeRef, "r" + string, new Integer(n3));
            return patternList.getDataType().getStateSet(n3);
        }
        boolean[] blArray = Parsimony.getParsimonyState(tree, tree.getChild(nodeRef, 0), patternList, n, string, nArray);
        int n4 = blArray.length;
        boolean[] blArray2 = new boolean[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            blArray2[n2] = blArray[n2];
        }
        n2 = 0;
        for (int i = 1; i < tree.getChildCount(nodeRef); ++i) {
            boolean[] blArray3 = Parsimony.getParsimonyState(tree, tree.getChild(nodeRef, i), patternList, n, string, nArray);
            for (int j = 0; j < blArray.length; ++j) {
                blArray[j] = blArray3[j] || blArray[j];
                boolean bl = blArray2[j] = blArray3[j] && blArray2[j];
                if (!blArray2[j]) continue;
                ++n2;
            }
        }
        if (nArray != null && n2 == 0) {
            nArray[0] = nArray[0] + 1;
        }
        if (string != null) {
            if (n2 == 0) {
                ((MutableTree)tree).setNodeAttribute(nodeRef, string, blArray);
            } else {
                ((MutableTree)tree).setNodeAttribute(nodeRef, string, blArray2);
            }
        }
        if (n2 == 0) {
            return blArray;
        }
        return blArray2;
    }
}

