## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

# Turn off all evaluation!
knitr::opts_chunk$set(eval = FALSE)

## -----------------------------------------------------------------------------
# x <- 1:3
# 
# # The current element, and 1 before it
# slider::slide(x, identity, .before = 1, .complete = TRUE)
# #> [[1]]
# #> NULL
# #>
# #> [[2]]
# #> [1] 1 2
# #>
# #> [[3]]
# #> [1] 2 3

## -----------------------------------------------------------------------------
# # Window size of 2, assume the current element is the right side of the window
# tsibble::slide(x, identity, .size = 2, .align = "right")
# #> [[1]]
# #> [1] NA
# #>
# #> [[2]]
# #> [1] 1 2
# #>
# #> [[3]]
# #> [1] 2 3

## -----------------------------------------------------------------------------
# # The current element, along with 1 before and 3 after (if they exist)
# slider::slide(1:6, identity, .before = 1, .after = 3)
# #> [[1]]
# #> [1] 1 2 3 4
# #>
# #> [[2]]
# #> [1] 1 2 3 4 5
# #>
# #> [[3]]
# #> [1] 2 3 4 5 6
# #>
# #> [[4]]
# #> [1] 3 4 5 6
# #>
# #> [[5]]
# #> [1] 4 5 6
# #>
# #> [[6]]
# #> [1] 5 6

## -----------------------------------------------------------------------------
# x <- 1:10
# 
# tsibble::tile(x, identity, .size = 3)
# #> [[1]]
# #> [1] 1 2 3
# #>
# #> [[2]]
# #> [1] 4 5 6
# #>
# #> [[3]]
# #> [1] 7 8 9
# #>
# #> [[4]]
# #> [1] 10

## -----------------------------------------------------------------------------
# result <- slider::slide(x, identity, .after = 2, .step = 3)
# result
# #> [[1]]
# #> [1] 1 2 3
# #>
# #> [[2]]
# #> NULL
# #>
# #> [[3]]
# #> NULL
# #>
# #> [[4]]
# #> [1] 4 5 6
# #>
# #> [[5]]
# #> NULL
# #>
# #> [[6]]
# #> NULL
# #>
# #> [[7]]
# #> [1] 7 8 9
# #>
# #> [[8]]
# #> NULL
# #>
# #> [[9]]
# #> NULL
# #>
# #> [[10]]
# #> [1] 10

## -----------------------------------------------------------------------------
# purrr::compact(result)
# #> [[1]]
# #> [1] 1 2 3
# #>
# #> [[2]]
# #> [1] 4 5 6
# #>
# #> [[3]]
# #> [1] 7 8 9
# #>
# #> [[4]]
# #> [1] 10

## -----------------------------------------------------------------------------
# x <- 1:4
# 
# tsibble::stretch(x, identity)
# #> [[1]]
# #> [1] 1
# #>
# #> [[2]]
# #> [1] 1 2
# #>
# #> [[3]]
# #> [1] 1 2 3
# #>
# #> [[4]]
# #> [1] 1 2 3 4

## -----------------------------------------------------------------------------
# slider::slide(x, identity, .before = Inf)
# #> [[1]]
# #> [1] 1
# #>
# #> [[2]]
# #> [1] 1 2
# #>
# #> [[3]]
# #> [1] 1 2 3
# #>
# #> [[4]]
# #> [1] 1 2 3 4

## -----------------------------------------------------------------------------
# tsibble::stretch(x, identity, .init = 3)
# #> [[1]]
# #> [1] NA
# #>
# #> [[2]]
# #> [1] NA
# #>
# #> [[3]]
# #> [1] 1 2 3
# #>
# #> [[4]]
# #> [1] 1 2 3 4

## -----------------------------------------------------------------------------
# identity3 <- function(x) {
#   if (length(x) < 3) {
#     NULL
#   } else {
#     x
#   }
# }
# 
# slider::slide(x, identity3, .before = Inf)
# #> [[1]]
# #> NULL
# #>
# #> [[2]]
# #> NULL
# #>
# #> [[3]]
# #> [1] 1 2 3
# #>
# #> [[4]]
# #> [1] 1 2 3 4

