/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.substmodel;

import dr.evolution.datatype.AminoAcids;
import dr.evolution.datatype.DataType;
import dr.inference.model.Parameter;
import dr.oldevomodel.substmodel.AbstractAminoAcidModel;
import dr.oldevomodel.substmodel.EmpiricalRateMatrix;
import dr.oldevomodel.substmodel.FrequencyModel;

public class EmpiricalAminoAcidModel
extends AbstractAminoAcidModel {
    private EmpiricalRateMatrix rateMatrix;
    private boolean areFrequenciesConstant = false;

    public EmpiricalAminoAcidModel(EmpiricalRateMatrix empiricalRateMatrix, FrequencyModel frequencyModel) {
        super(empiricalRateMatrix.getName(), frequencyModel);
        if (frequencyModel == null) {
            this.areFrequenciesConstant = true;
            double[] dArray = empiricalRateMatrix.getEmpiricalFrequencies();
            this.freqModel = new FrequencyModel((DataType)AminoAcids.INSTANCE, new Parameter.Default(dArray));
        }
        this.rateMatrix = empiricalRateMatrix;
    }

    @Override
    protected void frequenciesChanged() {
    }

    @Override
    protected void ratesChanged() {
    }

    @Override
    protected void setupRelativeRates() {
        double[] dArray = this.rateMatrix.getEmpiricalRates();
        System.arraycopy(dArray, 0, this.relativeRates, 0, this.relativeRates.length);
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
        this.updateMatrix = !this.areFrequenciesConstant;
    }

    @Override
    protected void acceptState() {
    }
}

