/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.io;

import dr.evolution.alignment.Alignment;
import dr.evolution.alignment.SimpleAlignment;
import dr.evolution.datatype.AminoAcids;
import dr.evolution.datatype.DataType;
import dr.evolution.datatype.Nucleotides;
import dr.evolution.datatype.TwoStates;
import dr.evolution.io.Importer;
import dr.evolution.io.NewickImporter;
import dr.evolution.io.SequenceImporter;
import dr.evolution.io.TreeImporter;
import dr.evolution.sequence.Sequence;
import dr.evolution.sequence.SequenceList;
import dr.evolution.sequence.Sequences;
import dr.evolution.tree.FlexibleNode;
import dr.evolution.tree.FlexibleTree;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.Date;
import dr.evolution.util.Taxa;
import dr.evolution.util.Taxon;
import dr.evolution.util.TaxonList;
import dr.evolution.util.Units;
import dr.util.Attributable;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NexusImporter
extends Importer
implements SequenceImporter,
TreeImporter {
    public static final NexusBlock UNKNOWN_BLOCK = new NexusBlock("unknown");
    public static final NexusBlock TAXA_BLOCK = new NexusBlock("TAXA");
    public static final NexusBlock CHARACTERS_BLOCK = new NexusBlock("CHARACTERS");
    public static final NexusBlock DATA_BLOCK = new NexusBlock("DATA");
    public static final NexusBlock UNALIGNED_BLOCK = new NexusBlock("UNALIGNED");
    public static final NexusBlock DISTANCES_BLOCK = new NexusBlock("DISTANCES");
    public static final NexusBlock TREES_BLOCK = new NexusBlock("TREES");
    public static final NexusBlock CALIBRATION_BLOCK = new NexusBlock("CALIBRATION");
    public static boolean suppressWarnings = false;
    private final boolean ignoreMetaComments;
    private boolean isReadingTreesBlock = false;
    private HashMap<String, Taxon> translationList = null;
    private Tree nextTree = null;
    private final String[] lastToken = new String[1];
    private NexusBlock nextBlock = null;
    private int taxonCount = 0;
    private int siteCount = 0;
    private DataType dataType = null;
    private String gapCharacters = "-";
    private String matchCharacters = ".";
    private String missingCharacters = "?";
    private boolean isInterleaved = false;

    public static void setSuppressWarnings(boolean bl) {
        suppressWarnings = bl;
    }

    public NexusImporter(Reader reader) {
        super(reader);
        this.ignoreMetaComments = false;
        this.setCommentDelimiters('[', ']', '\u0000', '\u0000', '&');
    }

    public NexusImporter(Reader reader, boolean bl) {
        super(reader);
        this.ignoreMetaComments = bl;
        this.setCommentDelimiters('[', ']', '\u0000', '!', '&');
    }

    public NexusImporter(Reader reader, Writer writer) {
        super(reader, writer);
        this.ignoreMetaComments = false;
        this.setCommentDelimiters('[', ']', '\u0000', '!', '&');
    }

    public NexusBlock findNextBlock() throws IOException {
        this.findToken("BEGIN", true);
        String string = this.readToken(";", true);
        return this.findBlockName(string);
    }

    public NexusBlock findBlockName(String string) {
        if (string.equalsIgnoreCase(TAXA_BLOCK.toString())) {
            this.nextBlock = TAXA_BLOCK;
        } else if (string.equalsIgnoreCase(CHARACTERS_BLOCK.toString())) {
            this.nextBlock = CHARACTERS_BLOCK;
        } else if (string.equalsIgnoreCase(DATA_BLOCK.toString())) {
            this.nextBlock = DATA_BLOCK;
        } else if (string.equalsIgnoreCase(UNALIGNED_BLOCK.toString())) {
            this.nextBlock = UNALIGNED_BLOCK;
        } else if (string.equalsIgnoreCase(DISTANCES_BLOCK.toString())) {
            this.nextBlock = DISTANCES_BLOCK;
        } else if (string.equalsIgnoreCase(TREES_BLOCK.toString())) {
            this.nextBlock = TREES_BLOCK;
        } else if (string.equalsIgnoreCase(CALIBRATION_BLOCK.toString())) {
            this.nextBlock = CALIBRATION_BLOCK;
        }
        return this.nextBlock;
    }

    public TaxonList parseTaxaBlock() throws Importer.ImportException, IOException {
        return this.readTaxaBlock();
    }

    public Alignment parseCharactersBlock(TaxonList taxonList) throws Importer.ImportException, IOException {
        return this.readCharactersBlock(taxonList);
    }

    public Alignment parseDataBlock(TaxonList taxonList) throws Importer.ImportException, IOException {
        return this.readDataBlock();
    }

    public List<Tree> parseTreesBlock(TaxonList taxonList) throws Importer.ImportException, IOException {
        return this.parseTreesBlock(taxonList, -1);
    }

    public List<Tree> parseTreesBlock(TaxonList taxonList, int n) throws Importer.ImportException, IOException {
        return this.readTreesBlock(taxonList, false, n);
    }

    public Date[] parseCalibrationBlock(TaxonList taxonList) throws Importer.ImportException, IOException {
        return this.readCalibrationBlock(taxonList);
    }

    @Override
    public Alignment importAlignment() throws IOException, Importer.ImportException {
        boolean bl = false;
        TaxonList taxonList = null;
        Alignment alignment = null;
        while (!bl) {
            try {
                NexusBlock nexusBlock = this.findNextBlock();
                if (nexusBlock == TAXA_BLOCK) {
                    taxonList = this.readTaxaBlock();
                    continue;
                }
                if (nexusBlock == CALIBRATION_BLOCK) {
                    if (taxonList == null) {
                        throw new MissingBlockException("TAXA block is missing");
                    }
                    this.readCalibrationBlock(taxonList);
                    continue;
                }
                if (nexusBlock == CHARACTERS_BLOCK) {
                    if (taxonList == null) {
                        throw new MissingBlockException("TAXA block is missing");
                    }
                    alignment = this.readCharactersBlock(taxonList);
                    bl = true;
                    continue;
                }
                if (nexusBlock != DATA_BLOCK) continue;
                alignment = this.readDataBlock();
                bl = true;
            }
            catch (EOFException eOFException) {
                bl = true;
            }
        }
        if (alignment == null) {
            throw new MissingBlockException("DATA or CHARACTERS block is missing");
        }
        return alignment;
    }

    @Override
    public SequenceList importSequences() throws IOException, Importer.ImportException {
        return this.importAlignment();
    }

    @Override
    public Tree importTree(TaxonList taxonList) throws IOException, Importer.ImportException {
        return this.importTree(taxonList, false);
    }

    public Tree importTree(TaxonList taxonList, boolean bl) throws IOException, Importer.ImportException {
        this.isReadingTreesBlock = false;
        TaxonList[] taxonListArray = new TaxonList[]{taxonList};
        if (!this.startReadingTrees(taxonListArray)) {
            throw new MissingBlockException("TREES block is missing");
        }
        this.translationList = this.readTranslationList(taxonListArray[0], this.lastToken);
        return this.readNextTree(this.translationList, this.lastToken, bl ? taxonList : null);
    }

    @Override
    public List<Tree> importTrees(TaxonList taxonList) throws IOException, Importer.ImportException {
        return this.importTrees(taxonList, false);
    }

    public List<Tree> importTrees(TaxonList taxonList, boolean bl) throws IOException, Importer.ImportException {
        this.isReadingTreesBlock = false;
        TaxonList[] taxonListArray = new TaxonList[]{taxonList};
        if (!this.startReadingTrees(taxonListArray)) {
            throw new MissingBlockException("TREES block is missing");
        }
        return this.readTreesBlock(taxonListArray[0], bl, -1);
    }

    @Override
    public int countTrees() throws IOException {
        int n = 0;
        try {
            String string = this.readLine(true).trim().toUpperCase();
            while (true) {
                if (string.startsWith("UTREE") || string.startsWith("TREE")) {
                    ++n;
                } else if (string.startsWith("ENDBLOCK") || string.startsWith("END")) {
                    return n;
                }
                string = this.readLine(true).trim().toUpperCase();
            }
        }
        catch (EOFException eOFException) {
            return n;
        }
    }

    @Override
    public boolean hasTree() throws IOException, Importer.ImportException {
        if (!this.isReadingTreesBlock) {
            TaxonList[] taxonListArray = new TaxonList[]{null};
            this.isReadingTreesBlock = this.startReadingTrees(taxonListArray);
            if (!this.isReadingTreesBlock) {
                return false;
            }
            this.translationList = this.readTranslationList(taxonListArray[0], this.lastToken);
        }
        if (this.nextTree == null) {
            this.nextTree = this.readNextTree(this.translationList, this.lastToken, null);
        }
        return this.nextTree != null;
    }

    @Override
    public Tree importNextTree() throws IOException, Importer.ImportException {
        if (!this.hasTree()) {
            this.isReadingTreesBlock = false;
            return null;
        }
        Tree tree = this.nextTree;
        this.nextTree = null;
        return tree;
    }

    public boolean startReadingTrees(TaxonList[] taxonListArray) throws IOException, Importer.ImportException {
        boolean bl = false;
        while (!bl) {
            try {
                NexusBlock nexusBlock = this.findNextBlock();
                if (nexusBlock == TAXA_BLOCK && taxonListArray[0] == null) {
                    taxonListArray[0] = this.readTaxaBlock();
                    continue;
                }
                if (nexusBlock != TREES_BLOCK) continue;
                return true;
            }
            catch (EOFException eOFException) {
                bl = true;
            }
        }
        return false;
    }

    private void findToken(String string, boolean bl) throws IOException {
        boolean bl2 = false;
        do {
            String string2 = this.readToken("", true);
            if ((!bl || !string2.equalsIgnoreCase(string)) && !string2.equals(string)) continue;
            bl2 = true;
        } while (!bl2);
    }

    public void findEndBlock() throws IOException {
        try {
            String string;
            while (!(string = this.readToken(";")).equalsIgnoreCase("END") && !string.equalsIgnoreCase("ENDBLOCK")) {
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        this.nextBlock = UNKNOWN_BLOCK;
    }

    private void readDataBlockHeader(String string, NexusBlock nexusBlock) throws Importer.ImportException, IOException {
        String string2;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        do {
            if ((string2 = this.readToken()).equalsIgnoreCase("TITLE")) {
                if (bl2) {
                    throw new Importer.DuplicateFieldException("TITLE");
                }
                bl2 = true;
                continue;
            }
            if (string2.equalsIgnoreCase("DIMENSIONS")) {
                if (bl) {
                    throw new Importer.DuplicateFieldException("DIMENSIONS");
                }
                boolean bl4 = nexusBlock == TAXA_BLOCK;
                boolean bl5 = nexusBlock == CHARACTERS_BLOCK;
                do {
                    String string3 = this.readToken("=;");
                    if (this.getLastDelimiter() != 61) {
                        throw new Importer.BadFormatException("Unknown subcommand, '" + string3 + "', or missing '=' in DIMENSIONS command");
                    }
                    if (string3.equalsIgnoreCase("NTAX")) {
                        if (nexusBlock == CHARACTERS_BLOCK) {
                            throw new Importer.BadFormatException("NTAX subcommand in CHARACTERS block");
                        }
                        this.taxonCount = this.readInteger(";");
                        bl5 = true;
                        continue;
                    }
                    if (string3.equalsIgnoreCase("NCHAR")) {
                        if (nexusBlock == TAXA_BLOCK) {
                            throw new Importer.BadFormatException("NCHAR subcommand in TAXA block");
                        }
                        this.siteCount = this.readInteger(";");
                        bl4 = true;
                        continue;
                    }
                    throw new Importer.BadFormatException("Unknown subcommand, '" + string3 + "', in DIMENSIONS command");
                } while (this.getLastDelimiter() != 59);
                if (!bl5) {
                    throw new Importer.BadFormatException("NTAX subcommand missing from DIMENSIONS command");
                }
                if (!bl4) {
                    throw new Importer.BadFormatException("NCHAR subcommand missing from DIMENSIONS command");
                }
                bl = true;
                continue;
            }
            if (!string2.equalsIgnoreCase("FORMAT")) continue;
            if (bl3) {
                throw new Importer.DuplicateFieldException("FORMAT");
            }
            this.dataType = null;
            do {
                String string4;
                if ((string4 = this.readToken("=;")).equalsIgnoreCase("GAP")) {
                    if (this.getLastDelimiter() != 61) {
                        throw new Importer.BadFormatException("Expecting '=' after GAP subcommand in FORMAT command");
                    }
                    this.gapCharacters = this.readToken(";");
                    continue;
                }
                if (string4.equalsIgnoreCase("MISSING")) {
                    if (this.getLastDelimiter() != 61) {
                        throw new Importer.BadFormatException("Expecting '=' after MISSING subcommand in FORMAT command");
                    }
                    this.missingCharacters = this.readToken(";");
                    continue;
                }
                if (string4.equalsIgnoreCase("MATCHCHAR")) {
                    if (this.getLastDelimiter() != 61) {
                        throw new Importer.BadFormatException("Expecting '=' after MATCHCHAR subcommand in FORMAT command");
                    }
                    this.matchCharacters = this.readToken(";");
                    continue;
                }
                if (string4.equalsIgnoreCase("DATATYPE")) {
                    if (this.getLastDelimiter() != 61) {
                        throw new Importer.BadFormatException("Expecting '=' after DATATYPE subcommand in FORMAT command");
                    }
                    String string5 = this.readToken(";");
                    if (string5.equalsIgnoreCase("NUCLEOTIDE") || string5.equalsIgnoreCase("DNA") || string5.equalsIgnoreCase("RNA")) {
                        this.dataType = Nucleotides.INSTANCE;
                        continue;
                    }
                    if (string5.equalsIgnoreCase("STANDARD") || string5.equalsIgnoreCase("BINARY")) {
                        this.dataType = TwoStates.INSTANCE;
                        continue;
                    }
                    if (string5.equalsIgnoreCase("PROTEIN")) {
                        this.dataType = AminoAcids.INSTANCE;
                        continue;
                    }
                    if (!string5.equalsIgnoreCase("CONTINUOUS")) continue;
                    throw new Importer.UnparsableDataException("Continuous data cannot be parsed at present");
                }
                if (!string4.equalsIgnoreCase("INTERLEAVE")) continue;
                this.isInterleaved = true;
            } while (this.getLastDelimiter() != 59);
            bl3 = true;
        } while (!string2.equalsIgnoreCase(string));
        if (!bl) {
            throw new Importer.MissingFieldException("DIMENSIONS");
        }
        if (nexusBlock != TAXA_BLOCK && this.dataType == null) {
            throw new Importer.MissingFieldException("DATATYPE");
        }
    }

    private void readSequenceData(Sequences sequences, TaxonList taxonList) throws Importer.ImportException, IOException {
        String string = null;
        if (this.isInterleaved) {
            int n;
            boolean bl = true;
            for (int i = 0; i < this.siteCount; i += n) {
                n = -1;
                for (int j = 0; j < this.taxonCount; ++j) {
                    Comparable<Taxon> comparable;
                    Sequence sequence;
                    String string2 = this.readToken().trim();
                    if (bl) {
                        sequence = new Sequence();
                        sequence.setDataType(this.dataType);
                        sequences.addSequence(sequence);
                        if (taxonList != null) {
                            int n2 = taxonList.getTaxonIndex(string2.trim());
                            if (n2 == -1) {
                                throw new Importer.UnknownTaxonException(string2);
                            }
                            comparable = taxonList.getTaxon(n2);
                        } else {
                            comparable = new Taxon(string2.trim());
                        }
                        sequence.setTaxon((Taxon)comparable);
                    } else {
                        sequence = sequences.getSequence(j);
                        comparable = sequence.getTaxon();
                        if (!((Taxon)comparable).getId().equals(string2)) {
                            throw new Importer.UnknownTaxonException("Unknown taxon label: expecting '" + ((Taxon)comparable).getId() + "', found '" + string2 + "'");
                        }
                    }
                    comparable = new StringBuilder();
                    this.readSequenceLine((StringBuilder)comparable, this.dataType, ";", this.gapCharacters, this.missingCharacters, this.matchCharacters, string);
                    String string3 = ((StringBuilder)comparable).toString();
                    sequence.appendSequenceString(string3);
                    if (j == 0) {
                        string = string3;
                    }
                    if (this.getLastDelimiter() == 59) {
                        if (j < this.taxonCount - 1) {
                            throw new Importer.TooFewTaxaException();
                        }
                        if (i + n < this.siteCount) {
                            throw new Importer.ShortSequenceException(sequence.getTaxon().getId());
                        }
                    }
                    if (n == -1) {
                        n = string3.length();
                    }
                    if (n == string3.length()) continue;
                    throw new Importer.ShortSequenceException(sequence.getTaxon().getId());
                }
                bl = false;
            }
            if (this.getLastDelimiter() != 59) {
                throw new Importer.BadFormatException("Expecting ';' after sequences data");
            }
        } else {
            for (int i = 0; i < this.taxonCount; ++i) {
                Taxon taxon;
                String string4 = this.readToken().trim();
                Sequence sequence = new Sequence();
                sequence.setDataType(this.dataType);
                sequences.addSequence(sequence);
                if (taxonList != null) {
                    int n = taxonList.getTaxonIndex(string4);
                    if (n == -1) {
                        throw new Importer.UnknownTaxonException(string4);
                    }
                    taxon = taxonList.getTaxon(n);
                } else {
                    taxon = new Taxon(string4);
                }
                sequence.setTaxon(taxon);
                StringBuilder stringBuilder = new StringBuilder();
                this.readSequence(stringBuilder, this.dataType, ";", this.siteCount, this.gapCharacters, this.missingCharacters, this.matchCharacters, string);
                String string5 = stringBuilder.toString();
                if (string5.length() != this.siteCount) {
                    throw new Importer.ShortSequenceException(sequence.getTaxon().getId());
                }
                sequence.appendSequenceString(string5);
                if (i == 0) {
                    string = string5;
                }
                if (this.getLastDelimiter() != 59 || i >= this.taxonCount - 1) continue;
                throw new Importer.TooFewTaxaException();
            }
            if (this.getLastDelimiter() != 59) {
                throw new Importer.BadFormatException("Expecting ';' after sequences data, has '" + (char)this.getLastDelimiter() + "' in line " + this.getLineNumber());
            }
        }
    }

    private TaxonList readTaxaBlock() throws Importer.ImportException, IOException, IllegalArgumentException {
        this.taxonCount = 0;
        this.readDataBlockHeader("TAXLABELS", TAXA_BLOCK);
        if (this.taxonCount == 0) {
            throw new Importer.MissingFieldException("NTAXA");
        }
        Taxa taxa = new Taxa();
        do {
            String string;
            if ((string = this.readToken(";").trim()).isEmpty()) continue;
            Taxon taxon = new Taxon(string);
            taxa.addTaxon(taxon);
        } while (this.getLastDelimiter() != 59);
        if (taxa.getTaxonCount() != this.taxonCount) {
            throw new Importer.BadFormatException("Number of taxa doesn't match NTAXA field");
        }
        this.findEndBlock();
        int n = TaxonList.Utils.findDuplicateTaxon(taxa);
        if (n >= 0) {
            throw new IllegalArgumentException("Tree contains duplicate taxon name: " + taxa.getTaxon(n).getId() + "!\nAll taxon names should be unique.");
        }
        return taxa;
    }

    private Alignment readCharactersBlock(TaxonList taxonList) throws Importer.ImportException, IOException {
        this.siteCount = 0;
        this.dataType = null;
        this.readDataBlockHeader("MATRIX", CHARACTERS_BLOCK);
        SimpleAlignment simpleAlignment = new SimpleAlignment();
        this.readSequenceData(simpleAlignment, taxonList);
        simpleAlignment.updateSiteCount();
        this.findEndBlock();
        return simpleAlignment;
    }

    private Alignment readDataBlock() throws Importer.ImportException, IOException {
        this.taxonCount = 0;
        this.siteCount = 0;
        this.dataType = null;
        this.readDataBlockHeader("MATRIX", DATA_BLOCK);
        SimpleAlignment simpleAlignment = new SimpleAlignment();
        this.readSequenceData(simpleAlignment, null);
        simpleAlignment.updateSiteCount();
        this.findEndBlock();
        return simpleAlignment;
    }

    private Set<String> getNames(Collection<Taxon> collection) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Taxon taxon : collection) {
            hashSet.add(taxon.getId());
        }
        return hashSet;
    }

    String notFoundInReference(Set<String> set, Set<String> set2) {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : set) {
            if (set2.contains(string)) continue;
            stringBuilder.append(" ").append(string);
            bl = true;
        }
        return bl ? stringBuilder.toString() : null;
    }

    private List<Tree> readTreesBlock(TaxonList taxonList, boolean bl, int n) throws Importer.ImportException, IOException {
        ArrayList<Tree> arrayList = new ArrayList<Tree>();
        String[] stringArray = new String[1];
        HashMap<String, Taxon> hashMap = this.readTranslationList(taxonList, stringArray);
        if (bl && hashMap.size() != taxonList.getTaxonCount()) {
            Set<String> set = this.getNames(taxonList.asList());
            Set<String> set2 = this.getNames(hashMap.values());
            String string = this.notFoundInReference(set2, set);
            String string2 = this.notFoundInReference(set, set2);
            throw new Importer.ImportException("Mismatch in taxa count in tree file (" + hashMap.size() + ") and <taxa> block (" + taxonList.getTaxonCount() + ")\n" + (string != null ? "Not found in list:" + string : "") + (string2 != null ? "Not found in file:" + string2 : ""));
        }
        int n2 = 0;
        boolean bl2 = false;
        do {
            Tree tree;
            if ((tree = this.readNextTree(hashMap, stringArray, bl ? taxonList : null)) != null) {
                arrayList.add(tree);
                if (n <= 0 || ++n2 != n) continue;
                bl2 = true;
                continue;
            }
            bl2 = true;
        } while (!bl2);
        if (arrayList.isEmpty()) {
            throw new Importer.BadFormatException("No trees defined in TREES block");
        }
        this.nextBlock = UNKNOWN_BLOCK;
        return arrayList;
    }

    private HashMap<String, Taxon> readTranslationList(TaxonList taxonList, String[] stringArray) throws Importer.ImportException, IOException {
        HashMap<String, Taxon> hashMap = new HashMap<String, Taxon>();
        String string = this.readToken(";");
        if (string.equalsIgnoreCase("TRANSLATE")) {
            do {
                Taxon taxon;
                String string2 = this.readToken(",;");
                if (this.getLastDelimiter() == 44 || this.getLastDelimiter() == 59) {
                    throw new Importer.BadFormatException("Missing taxon label in TRANSLATE command of TREES block");
                }
                String string3 = this.readToken(",;");
                if (this.getLastDelimiter() != 44 && this.getLastDelimiter() != 59) {
                    throw new Importer.BadFormatException("Expecting ',' or ';' after taxon label in TRANSLATE command of TREES block");
                }
                if (taxonList != null) {
                    int n = taxonList.getTaxonIndex(string3);
                    if (n == -1) {
                        throw new Importer.UnknownTaxonException("Taxon '" + string3 + "' in nexus '" + string + "' block but not in the taxon list (taxon list may or may not originate from the nexus file)");
                    }
                    taxon = taxonList.getTaxon(n);
                } else {
                    taxon = new Taxon(string3);
                }
                if (hashMap.containsKey(string2)) {
                    throw new Importer.BadFormatException("Translation list uses the key, " + string2 + ", more than once.");
                }
                hashMap.put(string2, taxon);
            } while (this.getLastDelimiter() != 59);
            string = this.readToken(";");
        } else if (taxonList != null) {
            for (int i = 0; i < taxonList.getTaxonCount(); ++i) {
                Taxon taxon = taxonList.getTaxon(i);
                hashMap.put(taxon.getId(), taxon);
            }
        }
        stringArray[0] = string;
        return hashMap;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private Tree readNextTree(HashMap<String, Taxon> var1_1, String[] var2_2, TaxonList var3_3) throws Importer.ImportException, IOException {
        try {
            var4_4 = null;
            var5_6 = var2_2[0];
            if (var5_6.equalsIgnoreCase("UTREE") || var5_6.equalsIgnoreCase("TREE")) {
                if (this.nextCharacter() == '*') {
                    this.readCharacter();
                }
                var6_7 = this.readToken("=;");
                var7_8 = this.getLastMetaComment();
                this.clearLastMetaComment();
                if (this.getLastDelimiter() != 61) {
                    throw new Importer.BadFormatException("Missing label for tree'" + var6_7 + "' or missing '=' in TREE command of TREES block");
                }
                try {
                    if (this.nextCharacter() != '(') {
                        throw new Importer.BadFormatException("Missing tree definition in TREE command of TREES block");
                    }
                    var8_9 = this.getLastMetaComment();
                    this.clearLastMetaComment();
                    var9_11 = this.readInternalNode(var1_1);
                    if (var1_1 != null) {
                        var10_12 = new HashMap<Taxon, Integer>();
                        var11_15 = 0;
                        for (Object var13_18 : var1_1.keySet()) {
                            var14_20 = var1_1.get(var13_18);
                            if (var3_3 != null) {
                                var15_21 = var3_3.getTaxonIndex(var14_20);
                            } else {
                                try {
                                    var15_21 = Integer.parseInt((String)var13_18) - 1;
                                }
                                catch (NumberFormatException var16_22) {
                                    var15_21 = var11_15;
                                }
                            }
                            var10_12.put(var14_20, var15_21);
                            ++var11_15;
                        }
                        var4_4 = new FlexibleTree(var9_11, false, true, (Map<Taxon, Integer>)var10_12);
                    } else {
                        var4_4 = new FlexibleTree(var9_11, false, true, null);
                    }
                    var4_4.setId(var6_7);
                    if (this.getLastDelimiter() == 58) {
                        this.readToken(";");
                        if (this.getLastMetaComment() != null) {
                            try {
                                NexusImporter.parseMetaCommentPairs(this.getLastMetaComment(), var9_11);
                            }
                            catch (Importer.BadFormatException var10_13) {
                                // empty catch block
                            }
                            this.clearLastMetaComment();
                        }
                    }
                    if (this.getLastDelimiter() != 59) {
                        throw new Importer.BadFormatException("Expecting ';' after tree, '" + var6_7 + "', TREE command of TREES block");
                    }
                    if (var8_9 != null) {
                        var10_12 = var8_9;
                        while (!var10_12.isEmpty()) {
                            var11_15 = var10_12.charAt(0);
                            if (var11_15 == 59) {
                                var10_12 = var10_12.substring(1);
                                continue;
                            }
                            if (var11_15 == 82) {
                                var10_12 = var10_12.substring(1);
                                continue;
                            }
                            if (var11_15 == 87) {
                                var12_17 = var10_12.indexOf(59);
                                if (var12_17 < 0) {
                                    var12_17 = var10_12.length();
                                }
                                try {
                                    var13_18 = Float.valueOf(Float.parseFloat(var10_12.substring(2, var12_17)));
                                    var4_4.setAttribute("weight", var13_18);
                                }
                                catch (NumberFormatException var13_19) {
                                    // empty catch block
                                }
                                var10_12 = var10_12.substring(var12_17);
                                continue;
                            }
                            var10_12 = var10_12.substring(1);
                        }
                    }
                    if (var7_8 == null) ** GOTO lbl88
                    try {
                        NexusImporter.parseMetaCommentPairs(var7_8, var4_4);
                    }
                    catch (Importer.BadFormatException var10_14) {
                        var4_4.setAttribute("comment", var7_8);
                    }
                }
                catch (EOFException var8_10) {
                    return var4_4;
                }
            } else {
                if (var5_6.equalsIgnoreCase("ENDBLOCK") || var5_6.equalsIgnoreCase("END")) {
                    return null;
                }
                throw new Importer.BadFormatException("Unknown command '" + var5_6 + "' in TREES block");
            }
lbl88:
            // 3 sources

            var5_6 = this.readToken(";");
            var2_2[0] = var5_6;
            return var4_4;
        }
        catch (EOFException var4_5) {
            return null;
        }
    }

    FlexibleNode readBranch(HashMap<String, Taxon> hashMap) throws IOException, Importer.ImportException {
        String string;
        double d = 0.0;
        this.clearLastMetaComment();
        FlexibleNode flexibleNode = this.nextCharacter() == '(' ? this.readInternalNode(hashMap) : this.readExternalNode(hashMap);
        if (this.getLastDelimiter() != 58 && this.getLastDelimiter() != 44 && this.getLastDelimiter() != 41 && !(string = this.readToken(",():;")).isEmpty()) {
            flexibleNode.setAttribute("label", string);
        }
        if (this.getLastDelimiter() == 58) {
            d = this.readDouble(",():;");
            if (this.getLastMetaComment() != null) {
                if (!this.ignoreMetaComments) {
                    try {
                        NexusImporter.parseMetaCommentPairs(this.getLastMetaComment(), flexibleNode);
                    }
                    catch (Importer.BadFormatException badFormatException) {
                        // empty catch block
                    }
                }
                this.clearLastMetaComment();
            }
        }
        flexibleNode.setLength(d);
        return flexibleNode;
    }

    FlexibleNode readInternalNode(HashMap<String, Taxon> hashMap) throws IOException, Importer.ImportException {
        FlexibleNode flexibleNode = new FlexibleNode();
        this.readCharacter();
        flexibleNode.addChild(this.readBranch(hashMap));
        if (this.getLastDelimiter() != 44 && !suppressWarnings) {
            Logger.getLogger("dr.evolution.io").warning("Internal node only has a single child.");
        }
        while (this.getLastDelimiter() == 44) {
            flexibleNode.addChild(this.readBranch(hashMap));
        }
        if (this.getLastDelimiter() != 41) {
            throw new Importer.BadFormatException("Missing closing ')' in tree in TREES block");
        }
        this.readToken(":(),;");
        if (this.getLastMetaComment() != null) {
            if (!this.ignoreMetaComments) {
                try {
                    NexusImporter.parseMetaCommentPairs(this.getLastMetaComment(), flexibleNode);
                }
                catch (Importer.BadFormatException badFormatException) {
                    // empty catch block
                }
            }
            this.clearLastMetaComment();
        }
        return flexibleNode;
    }

    FlexibleNode readExternalNode(HashMap<String, Taxon> hashMap) throws Importer.ImportException, IOException {
        Taxon taxon;
        FlexibleNode flexibleNode = new FlexibleNode();
        String string = this.readToken(":(),;");
        if (!hashMap.isEmpty()) {
            taxon = hashMap.get(string);
            if (taxon == null) {
                throw new Importer.UnknownTaxonException("Taxon in tree, '" + string + "' is unknown");
            }
        } else {
            taxon = new Taxon(string);
        }
        if (this.getLastMetaComment() != null) {
            if (!this.ignoreMetaComments) {
                try {
                    NexusImporter.parseMetaCommentPairs(this.getLastMetaComment(), flexibleNode);
                }
                catch (Importer.BadFormatException badFormatException) {
                    // empty catch block
                }
            }
            this.clearLastMetaComment();
        }
        flexibleNode.setTaxon(taxon);
        return flexibleNode;
    }

    private Date[] readCalibrationBlock(TaxonList taxonList) throws Importer.ImportException, IOException {
        Date[] dateArray;
        double d = 0.0;
        boolean bl = false;
        Units.Type type = Units.Type.YEARS;
        ArrayList<Date> arrayList = new ArrayList<Date>();
        boolean bl2 = false;
        do {
            String string;
            if ((string = this.readToken(";")).equalsIgnoreCase("OPTIONS")) {
                do {
                    String string2;
                    dateArray = this.readToken("=;");
                    if (this.getLastDelimiter() != 61) {
                        throw new Importer.BadFormatException("Unknown subcommand, '" + (String)dateArray + "', or missing '=' in OPTIONS command of CALIBRATION block");
                    }
                    if (dateArray.equalsIgnoreCase("SCALE")) {
                        string2 = this.readToken(";");
                        if (string2.equalsIgnoreCase("DAYS")) {
                            type = Units.Type.DAYS;
                            continue;
                        }
                        if (string2.equalsIgnoreCase("MONTHS")) {
                            type = Units.Type.MONTHS;
                            continue;
                        }
                        if (string2.equalsIgnoreCase("YEARS")) {
                            type = Units.Type.YEARS;
                            continue;
                        }
                        throw new Importer.BadFormatException("SCALE in OPTIONS command of CALIBRATION block must be one of DAYS, MONTHS or YEARS");
                    }
                    if (dateArray.equalsIgnoreCase("ORIGIN")) {
                        d = this.readDouble(";");
                        continue;
                    }
                    if (dateArray.equalsIgnoreCase("DIRECTION")) {
                        string2 = this.readToken(";");
                        if (string2.equalsIgnoreCase("FORWARDS")) {
                            bl = false;
                            continue;
                        }
                        if (string2.equalsIgnoreCase("BACKWARDS")) {
                            bl = true;
                            continue;
                        }
                        throw new Importer.BadFormatException("DIRECTION in OPTIONS command of CALIBRATION block must be either FORWARDS or BACKWARDS");
                    }
                    throw new Importer.BadFormatException("Unknown subcommand, '" + (String)dateArray + "', in OPTIONS command of CALIBRATION block");
                } while (this.getLastDelimiter() != 59);
                continue;
            }
            if (string.equalsIgnoreCase("TIPCALIBRATION")) {
                do {
                    dateArray = this.readToken("=;");
                    if (this.getLastDelimiter() != 61) {
                        throw new Importer.BadFormatException("Missing date for label '" + (String)dateArray + "' or missing '=' in TIPCALIBRATION command of CALIBRATION block");
                    }
                    double d2 = this.readDouble(":;");
                    if (this.getLastDelimiter() != 58) {
                        throw new Importer.BadFormatException("Missing taxon list for label '" + (String)dateArray + "' or missing ':' in TIPCALIBRATION command of CALIBRATION block");
                    }
                    Date date = bl ? Date.createTimeAgoFromOrigin(d2, type, d) : Date.createTimeSinceOrigin(d2, type, d);
                    arrayList.add(date);
                    do {
                        String string3;
                        int n;
                        if ((n = taxonList.getTaxonIndex(string3 = this.readToken(",;"))) == -1) {
                            throw new Importer.UnknownTaxonException("Unknown taxon '" + string3 + "' for label '" + (String)dateArray + "' in TIPCALIBRATION command of CALIBRATION block");
                        }
                        Taxon taxon = taxonList.getTaxon(n);
                        taxon.setAttribute("date", date);
                    } while (this.getLastDelimiter() != 44 && this.getLastDelimiter() != 59);
                } while (this.getLastDelimiter() == 44);
                continue;
            }
            if (string.equalsIgnoreCase("NODECALIBRATION")) {
                throw new Importer.BadFormatException("NODECALIBRATION not suppored in CALIBRATION block");
            }
            if (string.equalsIgnoreCase("ENDBLOCK") || string.equalsIgnoreCase("END")) {
                bl2 = true;
                continue;
            }
            throw new Importer.BadFormatException("Unknown command '" + string + "' in CALIBRATION block");
        } while (!bl2);
        dateArray = new Date[arrayList.size()];
        arrayList.toArray(dateArray);
        this.nextBlock = UNKNOWN_BLOCK;
        return dateArray;
    }

    static void parseMetaCommentPairs(String string, Attributable attributable) throws Importer.BadFormatException {
        if (string.startsWith("B ")) {
            String[] stringArray = string.split(" ");
            if (stringArray.length == 3 && stringArray[1].length() > 0 && stringArray[2].length() > 0) {
                attributable.setAttribute(stringArray[1], NexusImporter.parseValue(stringArray[2]));
            } else if (stringArray.length == 2 && stringArray[1].length() > 0) {
                attributable.setAttribute(stringArray[1], Boolean.TRUE);
            } else {
                throw new Importer.BadFormatException("Badly formatted attribute: '" + string + "'");
            }
            return;
        }
        Pattern pattern = Pattern.compile("(\"[^\"]*\"+|[^,=\\s]+)\\s*(=\\s*(\\{[^=]*\\}|\"[^\"]*\"+|[^,]+))?");
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group(1);
            if (string2.length() > 1 && string2.startsWith("\"")) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            if (string2.trim().length() == 0) {
                throw new Importer.BadFormatException("Badly formatted attribute: '" + matcher.group() + "'");
            }
            String string3 = matcher.group(2);
            if (string3 != null && string3.trim().length() > 0) {
                attributable.setAttribute(string2, NexusImporter.parseValue(string3.substring(1)));
                continue;
            }
            attributable.setAttribute(string2, Boolean.TRUE);
        }
    }

    public static boolean isInt(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        if (n == 0) {
            return false;
        }
        int n2 = 0;
        if (string.charAt(0) == '-') {
            if (n == 1) {
                return false;
            }
            n2 = 1;
        }
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c <= '/' || c >= ':') {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static Serializable parseValue(String string) {
        if ((string = string.trim()).startsWith("{")) {
            int n;
            Object[] objectArray;
            String[] stringArray;
            StringBuilder stringBuilder;
            String string2 = string.substring(1, string.length() - 1);
            if (string2.length() == 0) {
                return null;
            }
            int n2 = 0;
            while (string2.charAt(n2) == '{') {
                ++n2;
            }
            if (n2 == 0) {
                stringBuilder = new StringBuilder(",");
            } else {
                stringArray = new StringBuilder("(?<=");
                objectArray = new StringBuilder("(?=");
                for (n = 0; n < n2; ++n) {
                    stringArray.append("\\}");
                    objectArray.append("\\{");
                }
                objectArray.append(")");
                stringArray.append(")");
                stringBuilder = stringArray.append(",").append((CharSequence)objectArray);
            }
            stringArray = string2.split(stringBuilder.toString());
            objectArray = new Object[stringArray.length];
            for (n = 0; n < stringArray.length; ++n) {
                objectArray[n] = NexusImporter.parseValue(stringArray[n]);
            }
            return objectArray;
        }
        if (string.startsWith("#")) {
            try {
                return Color.decode(string.substring(1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (string.equalsIgnoreCase("TRUE") || string.equalsIgnoreCase("FALSE")) {
            return Boolean.valueOf(string);
        }
        if (NexusImporter.isInt(string)) {
            return Integer.valueOf(string);
        }
        try {
            return Double.valueOf(Double.parseDouble(string));
        }
        catch (NumberFormatException numberFormatException) {
            if (string.charAt(0) == '\"') {
                string = string.substring(1, string.length() - 1);
            }
            return string;
        }
    }

    public static void main(String[] stringArray) throws IOException, Importer.ImportException {
        if (stringArray.length > 3) {
            int n = Integer.parseInt(stringArray[1]);
            boolean bl = Boolean.getBoolean(stringArray[2]);
            boolean bl2 = Boolean.getBoolean(stringArray[3]);
            NexusImporter nexusImporter = null;
            BufferedReader bufferedReader = null;
            if (bl2) {
                nexusImporter = new NexusImporter(new FileReader(stringArray[0]));
            } else {
                bufferedReader = new BufferedReader(new FileReader(stringArray[0]));
            }
            int n2 = 0;
            int n3 = 0;
            String string = null;
            if (!bl2) {
                string = bufferedReader.readLine();
            }
            while (string != null || bl2 && nexusImporter.hasTree()) {
                Tree tree;
                if (bl2) {
                    tree = nexusImporter.importNextTree();
                } else {
                    String string2 = string.substring(string.indexOf(40)).trim();
                    StringReader stringReader = new StringReader(string2);
                    NewickImporter newickImporter = new NewickImporter(stringReader);
                    tree = newickImporter.importNextTree();
                }
                if (n2 % n == 0) {
                    if (bl) {
                        System.out.println(TreeUtils.newick(tree));
                    } else {
                        System.out.println(TreeUtils.newickNoLengths(tree));
                        ++n3;
                    }
                }
                ++n2;
                if (bl2) continue;
                string = bufferedReader.readLine();
            }
            System.out.println(n3 + " trees");
        } else {
            System.err.println("usage: filterTrees <tree-file-name> <sample-frequency> <include-branch-lengths>");
        }
    }

    public static class NexusBlock {
        private final String name;

        public NexusBlock(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class MissingBlockException
    extends Importer.ImportException {
        private static final long serialVersionUID = -6287423449717453999L;

        public MissingBlockException() {
        }

        public MissingBlockException(String string) {
            super(string);
        }
    }
}

