> Create a (reproducible) report using Rmarkdown

The best way to store your work in Radiant is to use the _Report > Rmd_ feature and save a state file with all your results and settings. The report feature in Radiant should be used in conjunction with the <i title='Report results' class='fa fa-edit'></i> icons shown on the bottom left of your screen on most pages.

The editor shown on the left in _Report > Rmd_ shows past commands in **R-code chunks**. These _chunks_ can include R-code you typed or R-code generated by Radiant and added to the report after clicking an <i title='Report results' class='fa fa-edit'></i> icon. All code chunks start with ```` ```{r} ```` and are closed by ```` ``` ````

By default Radiant will add the R-code generated for the analysis you just completed to the bottom of the report. After clicking a <i title='Report results' class='fa fa-edit'></i> icon Radiant will, by default, switch to the _Report > Rmd_ tab. Click inside the editor window on the left and scroll down to see the generated commands. 

If you want more control over where the R-code generated by Radiant is put into your report, choose `Manual paste` instead or `Auto paste` from the appropriate drop-down in the _Report > Rmd_ tab. When `Manual paste` is selected, the code is put into the clipboard when you click <i title='Report results' class='fa fa-edit'></i> and you can paste it where you want in the editor window.

If you started Radiant from Rstudio, you can also choose to have commands sent to an Rmarkdown (R-code) document open in Rstudio by selecting `To Rmd` (`To R`) instead of `Auto paste` or `Manual paste`. If you choose `To Rmd` the editor in _Report > Rmd_ will be hidden (i.e., "Preview only") and clicking on `Knit report (Rmd)` will source the text and code directly from Rstudio. 

By default, the app will switch to the _Report > Rmd_ tab after you click the <i title='Report results' class='fa fa-edit'></i> icon. However, if you don't want to switch tabs after clicking  a <i title='Report results' class='fa fa-edit'></i> icon, choose `Don't switch tab` from the appropriate drop-down in the _Report > Rmd_ tab. `Don't switch tab` is the default option when you choose `To Rmd`.

You can add text or additional commands to create an Rmarkdown document. An Rmarkdown file (extension .Rmd) is a plain text file that can be opened in Notepad (Windows), TextEdit (Mac), Rstudio, Sublime Text, or any other text editor. Please do **not** use Word to edit Rmarkdown files.

Using Rmarkdown is extremely powerful because you can replicate your entire analysis quickly without having to generate all the required R-code again. By clicking the `Knit report (Rmd)` button on the top-left of your screen, the output from the analysis will be (re)created and shown on the right of the _Report > Rmd_ page. To evaluate only a part of the report use the cursor to select a section and press `CTRL-enter` (`CMD-enter` on mac) to create the (partial) output.

You can add text, bullets, headers, etc. around the code chunks to describe and explain the results using <a href="https://rmarkdown.rstudio.com/authoring_pandoc_markdown.html" target="_blank">markdown</a>. For an interactive markdown tutorial visit <a href="http://commonmark.org/help/" target="_blank">commonmark.org</a>.

If you started Radiant from Rstudio you can save the report in various formats (i.e., Notebook, HTML, Word, Powerpoint, or PDF). For  more on generating powerpoint presentation see <a href="https://bookdown.org/yihui/rmarkdown/powerpoint-presentation.html" target="_blank">https://bookdown.org/yihui/rmarkdown/powerpoint-presentation.html</a>. To save the Rmarkdown file open in the editor select `Rmd` (or `Rmd + Data (zip)`) and press `Save report`. Previously saved Rmarkdown files can be loaded into Radiant by using the `Load report` button. For more 

You can also click the `Read files` button to browse for files and generate code to read it into Radiant. For example, read rda, rds, xls, yaml, and feather and add them to the `Datasets` dropdown. You can also read images, R-code, and text (e.g., Rmd or md) to include in your report. If the file type you want to load is not currently supported, the path to the file will be returned. If Radiant was started from an Rstudio project, the file paths used will be relative to the project root. Paths to files synced to local Dropbox or Google Drive folder will use the `find_dropbox` and `find_gdrive` functions to enhances reproducibility.

## State

The best way to save your analyses and settings is to save the `state` of the application to a file by clicking on the <i title='Save' class='fa fa-save'></i> icon in the navbar and then clicking on `Save radiant state file`. The state file (extension rda) will contain (1) the data loaded in Radiant, (2) settings for the analyses you were working on, (3) and any reports or code from the _Report > Rmd_ and _Report > R_. Save the state file to your hard-disk and, when you are ready to continue, simply load it by <i title='Save' class='fa fa-save'></i> icon in the navbar and then clicking on `Load radiant state file`

If you are using Radiant for a class I suggest you use the _Report > Rmd_ feature to complete assignments and cases. When you are done, generate an (HTML) Notebook (or Word or PDF) report by clicking the `Save report` button. Submit both the report and your state file.

## Options

The editor used in _Report > Rmd_ and _Report > R_ has several options that can be set in `.Rprofile`. You can use `usethis::edit_r_profile()` to alter the settings in .Rprofile

```r
options(radiant.ace_vim.keys = FALSE)
options(radiant.ace_theme = "cobalt")
options(radiant.ace_tabSize = 2)
options(radiant.ace_useSoftTabs = TRUE)
options(radiant.ace_showInvisibles = TRUE)
options(radiant.ace_autoComplete = "live")
options(radiant.powerpoint_style = "~/Dropbox/rmd-styles/style.potx")
options(radiant.word_style = "~/Dropbox/rmd-styles/style.docx")
options(radiant.theme = bslib::bs_theme(version = 4, bootswatch = "darkly"))
```

Notes:

* `vim.keys` enables a set of special keyboard short-cuts. If you have never used VIM you probably don't want this 
* For an overview of available editor themes see: `shinyAce::getAceThemes()`
* Tabs are converted to 2 spaces by default (i.e., 'soft' tabs). You can change the number of spaces used from 2 to, for example, 4
* `showInvisibles` shows tabs and spaces in the editor
* Autocomplete has options "live", "enabled", and "disabled" 
* Radiant has default styles for Word and Powerpoint files. These can be replaced with styles files you created however. Click the links below to download the style files used in Radiant to your computer. Edit the files and use `options` as shown above to tell Radiant where to find the style files you want to use.
    * <a href="https://github.com/radiant-rstats/radiant.data/raw/master/inst/app/www/style.docx" target="_blank">Word style file</a>
    * <a href="https://github.com/radiant-rstats/radiant.data/raw/master/inst/app/www/style.potx" target="_blank">Powerpoint style file</a>
* The `theme` option can be used to change the appearance of the Radiant interface. For an overview of available themes see: <a href="https://rstudio.github.io/bslib/articles/theming/index.html#bootswatch" target="_blank">https://rstudio.github.io/bslib/articles/theming/index.html#bootswatch</a>

### R-functions

For an overview of related R-functions used by Radiant to generate reproducible reports see <a href = " https://radiant-rstats.github.io/radiant.data/reference/index.html#section-data-report" target="_blank">_Report_</a>
