### R code from vignette source 'lmPerm.Rnw'

###################################################
### code chunk number 1: lmPerm.Rnw:30-35
###################################################
# needed to make stars output look OK
useFancyQuotesSave<-getOption("useFancyQuotes")
options(useFancyQuotes=FALSE)
widthSave<-getOption("width")
options(width=55)


###################################################
### code chunk number 2: lmPerm.Rnw:141-144
###################################################
library(lmPerm)
data(CC164)
summary(lmp(y~P*N,data=CC164, perm="Exact"))


###################################################
### code chunk number 3: lmPerm.Rnw:167-168
###################################################
summary(lmp(y ~ P * N, data = CC164, perm="Prob"))


###################################################
### code chunk number 4: lmPerm.Rnw:220-221
###################################################
anova(lmp(y~P*N,CC164))


###################################################
### code chunk number 5: lmPerm.Rnw:238-239
###################################################
summary(aovp(y~P*N+Error(Block),CC164))


###################################################
### code chunk number 6: lmPerm.Rnw:252-253
###################################################
data(Hald17.4)


###################################################
### code chunk number 7: lmPerm.Rnw:255-256
###################################################
summary(aovp(Y~T+Error(block),Hald17.4))


###################################################
### code chunk number 8: lmPerm.Rnw:266-267
###################################################
summary(aovp(Y~T+L+Error(block),Hald17.4))


###################################################
### code chunk number 9: lmPerm.Rnw:281-282
###################################################
data(Quinlan)


###################################################
### code chunk number 10: lmPerm.Rnw:310-311
###################################################
summary(lmp(SN~.,Quinlan))


###################################################
### code chunk number 11: lmPerm.Rnw:331-332
###################################################
data(composite)


###################################################
### code chunk number 12: lmPerm.Rnw:334-335
###################################################
anova(lmp(strength~laser*tape,composite))


###################################################
### code chunk number 13: lmPerm.Rnw:357-358
###################################################
data(simDesignPartNumeric)


###################################################
### code chunk number 14: lmPerm.Rnw:360-361
###################################################
anova(lmp(poly.formula(Y~quad(A,B)+C),simDesignPartNumeric))


###################################################
### code chunk number 15: lmPerm.Rnw:369-372
###################################################
poly.formula(Y~quad(A,B,C))
poly.formula(Y~cubic(A,B,C))
poly.formula(Y~cubicS(A,B,C))


###################################################
### code chunk number 16: lmPerm.Rnw:381-382
###################################################
data(Plasma)


###################################################
### code chunk number 17: lmPerm.Rnw:384-385
###################################################
anova(lmp(multResp(Amin,Pct,sinpoly)~.,Plasma))


###################################################
### code chunk number 18: lmPerm.Rnw:396-397
###################################################
data(ghoctane)


###################################################
### code chunk number 19: lmPerm.Rnw:400-401
###################################################
ghoctane


###################################################
### code chunk number 20: lmPerm.Rnw:436-437
###################################################
anova(lmp(ON~.^3-1,ghoctane))


###################################################
### code chunk number 21: lmPerm.Rnw:505-507
###################################################
data(ratGenotype)
replications(~litter*mother,ratGenotype)


###################################################
### code chunk number 22: lmPerm.Rnw:514-515
###################################################
anova(lmp(wt~litter*mother,ratGenotype,seqs=TRUE))


###################################################
### code chunk number 23: lmPerm.Rnw:524-525
###################################################
anova(lmp(wt~litter*mother,ratGenotype,seqs=FALSE))


###################################################
### code chunk number 24: lmPerm.Rnw:544-545
###################################################
anova(lmp(wt~litter*mother,ratGenotype,contrasts=list(mother=contr.treatment(4))))


###################################################
### code chunk number 25: lmPerm.Rnw:581-583
###################################################
data(manly126)
manly126


###################################################
### code chunk number 26: lmPerm.Rnw:897-901
###################################################
options(useFancyQuotes=useFancyQuotesSave)
rm(useFancyQuotesSave)
options(width=widthSave)
rm(widthSave)


