/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.map.tint;

import cern.colt.GenericSorting;
import cern.colt.Swapper;
import cern.colt.function.tint.IntComparator;
import cern.colt.function.tint.IntFunction;
import cern.colt.function.tint.IntIntProcedure;
import cern.colt.function.tint.IntProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.map.AbstractMap;

public abstract class AbstractIntIntMap
extends AbstractMap {
    private static final long serialVersionUID = 1L;

    protected AbstractIntIntMap() {
    }

    public void assign(final IntFunction intFunction) {
        this.copy().forEachPair(new IntIntProcedure(){

            public boolean apply(int n, int n2) {
                AbstractIntIntMap.this.put(n, intFunction.apply(n2));
                return true;
            }
        });
    }

    public void assign(AbstractIntIntMap abstractIntIntMap) {
        this.clear();
        abstractIntIntMap.forEachPair(new IntIntProcedure(){

            public boolean apply(int n, int n2) {
                AbstractIntIntMap.this.put(n, n2);
                return true;
            }
        });
    }

    public boolean containsKey(final int n) {
        return !this.forEachKey(new IntProcedure(){

            public boolean apply(int n2) {
                return n != n2;
            }
        });
    }

    public boolean containsValue(final int n) {
        return !this.forEachPair(new IntIntProcedure(){

            public boolean apply(int n3, int n2) {
                return n != n2;
            }
        });
    }

    public AbstractIntIntMap copy() {
        return (AbstractIntIntMap)this.clone();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AbstractIntIntMap)) {
            return false;
        }
        final AbstractIntIntMap abstractIntIntMap = (AbstractIntIntMap)object;
        if (abstractIntIntMap.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new IntIntProcedure(){

            public boolean apply(int n, int n2) {
                return abstractIntIntMap.containsKey(n) && abstractIntIntMap.get(n) == n2;
            }
        }) && abstractIntIntMap.forEachPair(new IntIntProcedure(){

            public boolean apply(int n, int n2) {
                return AbstractIntIntMap.this.containsKey(n) && AbstractIntIntMap.this.get(n) == n2;
            }
        });
    }

    public abstract boolean forEachKey(IntProcedure var1);

    public boolean forEachPair(final IntIntProcedure intIntProcedure) {
        return this.forEachKey(new IntProcedure(){

            public boolean apply(int n) {
                return intIntProcedure.apply(n, AbstractIntIntMap.this.get(n));
            }
        });
    }

    public abstract int get(int var1);

    public int keyOf(final int n) {
        final int[] nArray = new int[1];
        boolean bl = this.forEachPair(new IntIntProcedure(){

            public boolean apply(int n3, int n2) {
                boolean bl;
                boolean bl2 = bl = n == n2;
                if (bl) {
                    nArray[0] = n3;
                }
                return !bl;
            }
        });
        if (bl) {
            return Integer.MIN_VALUE;
        }
        return nArray[0];
    }

    public IntArrayList keys() {
        IntArrayList intArrayList = new IntArrayList(this.size());
        this.keys(intArrayList);
        return intArrayList;
    }

    public void keys(final IntArrayList intArrayList) {
        intArrayList.clear();
        this.forEachKey(new IntProcedure(){

            public boolean apply(int n) {
                intArrayList.add(n);
                return true;
            }
        });
    }

    public void keysSortedByValue(IntArrayList intArrayList) {
        this.pairsSortedByValue(intArrayList, new IntArrayList(this.size()));
    }

    public void pairsMatching(final IntIntProcedure intIntProcedure, final IntArrayList intArrayList, final IntArrayList intArrayList2) {
        intArrayList.clear();
        intArrayList2.clear();
        this.forEachPair(new IntIntProcedure(){

            public boolean apply(int n, int n2) {
                if (intIntProcedure.apply(n, n2)) {
                    intArrayList.add(n);
                    intArrayList2.add(n2);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(IntArrayList intArrayList, IntArrayList intArrayList2) {
        this.keys(intArrayList);
        intArrayList.sort();
        intArrayList2.setSize(intArrayList.size());
        int n = intArrayList.size();
        while (--n >= 0) {
            intArrayList2.setQuick(n, this.get(intArrayList.getQuick(n)));
        }
    }

    public void pairsSortedByValue(IntArrayList intArrayList, IntArrayList intArrayList2) {
        this.keys(intArrayList);
        this.values(intArrayList2);
        final int[] nArray = intArrayList.elements();
        final int[] nArray2 = intArrayList2.elements();
        Swapper swapper = new Swapper(){

            public void swap(int n, int n2) {
                int n3 = nArray2[n];
                nArray2[n] = nArray2[n2];
                nArray2[n2] = n3;
                int n4 = nArray[n];
                nArray[n] = nArray[n2];
                nArray[n2] = n4;
            }
        };
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n2) {
                return nArray2[n] < nArray2[n2] ? -1 : (nArray2[n] > nArray2[n2] ? 1 : (nArray[n] < nArray[n2] ? -1 : (nArray[n] == nArray[n2] ? 0 : 1)));
            }
        };
        GenericSorting.quickSort(0, intArrayList.size(), intComparator, swapper);
    }

    public abstract boolean put(int var1, int var2);

    public abstract boolean removeKey(int var1);

    public String toString() {
        IntArrayList intArrayList = this.keys();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = intArrayList.size() - 1;
        for (int i = 0; i <= n; ++i) {
            int n2 = intArrayList.get(i);
            stringBuffer.append(String.valueOf(n2));
            stringBuffer.append("->");
            stringBuffer.append(String.valueOf(this.get(n2)));
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String toStringByValue() {
        IntArrayList intArrayList = new IntArrayList();
        this.keysSortedByValue(intArrayList);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = intArrayList.size() - 1;
        for (int i = 0; i <= n; ++i) {
            int n2 = intArrayList.get(i);
            stringBuffer.append(String.valueOf(n2));
            stringBuffer.append("->");
            stringBuffer.append(String.valueOf(this.get(n2)));
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public IntArrayList values() {
        IntArrayList intArrayList = new IntArrayList(this.size());
        this.values(intArrayList);
        return intArrayList;
    }

    public void values(final IntArrayList intArrayList) {
        intArrayList.clear();
        this.forEachKey(new IntProcedure(){

            public boolean apply(int n) {
                intArrayList.add(AbstractIntIntMap.this.get(n));
                return true;
            }
        });
    }
}

