
# FSK2R 0.2.0

## Major New Features

* **Dynamic Script Detection**: `import_fsk()` now dynamically detects model and visualization script filenames from metadata.rdf instead of hardcoding "model.r" and "visualization.r". This enables support for FSKX files with non-standard script names.

* **Complete Temporary Folder Execution**: `run_simulation()` now executes models in their unpacked temporary directory, solving file loading issues for models that depend on CSV, Excel, and other data files (e.g., QMRA models).

* **Workspace Copying Functionality**: Added optional workspace copying with intelligent directory naming:
  - New parameters: `copy_workspace` and `workspace_mode` in `run_simulation()` and `run_all_simulations()`
  - Creates directories named: `fsk_workspace_[model_name]_[simulation_name]/`
  - Three copy modes: "all" (complete workspace), "generated" (new files only), "modified" (changed files only)

* **Model Chaining Support**: Added `inject_to_global` parameter enabling seamless model chaining workflows:
  - New parameter: `inject_to_global` in `run_simulation()` and `run_all_simulations()`
  - When TRUE, simulation variables are injected directly into the user's global environment
  - Enables users to access simulation results directly without complex variable extraction
  - Facilitates model chaining: use results from Model A as inputs to Model B
  - Maintains backward compatibility (FALSE by default)

## Bug Fixes and Improvements

* Cross-platform line endings: All textual files exported into FSKX archives now use LF line endings on every OS (including Windows). This applies to:
  - README.txt, metaData.json, packages.json, manifest.xml, metadata.rdf
  - model and visualization scripts
  - workspace.r
  - sim.sedml and model.sbml
* Other files: R scripts included via `other_files` are normalized to LF on export; other file types are copied unchanged.
* Encoding: All textual exports are written as UTF-8 (no BOM).
* Internal: Introduced `write_text_lf()` helper to normalize line endings and write via binary connections; XML writers now use binary connections; zipping uses utils::zip to preserve directory structure.
* **File Loading Fix**: Models that load external files (CSV, Excel, etc.) now work correctly by executing in the proper temporary directory with automatic working directory restoration.

* **Enhanced Return Values**: `run_simulation()` now returns all user-created variables with preserved data types (scalars, vectors, data frames, lists, matrices) .

* **Improved Visualization Handling**: Enhanced automatic display of ggplot objects created by visualization scripts.

* **Package Build Optimization**: Added comprehensive `.Rbuildignore` file to exclude development files (test projects, debug scripts, session artifacts) from package builds.

* **Robust Error Handling**: Added proper error handling and cleanup for working directory management and workspace copying operations.

* **Updated Documentation**: Enhanced function documentation to reflect new parameters and capabilities.

## Breaking Changes

* None - all changes are backward compatible with existing workflows.

# FSK2R 0.1.3

* Removed the googlesheets dependencies due to archiving of that package.
* Small updates in the documentation, especially to adapt to new terminologies.

# FSK2R 0.1.2

* Added a `NEWS.md` file to track changes to the package.
* Improved the function documentation.
