/*
 * Decompiled with CFR 0.152.
 */
package dr.math.matrixAlgebra;

import dr.math.matrixAlgebra.IllegalDimension;
import java.util.Arrays;
import org.ejml.data.DenseMatrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.interfaces.decomposition.SingularValueDecomposition;
import org.ejml.ops.CommonOps;

public class EJMLUtils {
    private static final Boolean DEBUG = false;

    public static void addWithTransposed(DenseMatrix64F denseMatrix64F) {
        EJMLUtils.checkSquare(denseMatrix64F);
        for (int i = 0; i < denseMatrix64F.numCols; ++i) {
            double d = denseMatrix64F.get(i, i);
            denseMatrix64F.set(i, i, d * 2.0);
            for (int j = i + 1; j < denseMatrix64F.numCols; ++j) {
                double d2 = denseMatrix64F.get(i, j);
                double d3 = denseMatrix64F.get(j, i);
                double d4 = d2 + d3;
                denseMatrix64F.set(i, j, d4);
                denseMatrix64F.set(j, i, d4);
            }
        }
    }

    public static void setIdentity(DenseMatrix64F denseMatrix64F) {
        EJMLUtils.setScaledIdentity(denseMatrix64F, 1.0);
    }

    public static void setScaledIdentity(DenseMatrix64F denseMatrix64F, double d) {
        EJMLUtils.checkSquare(denseMatrix64F);
        Arrays.fill(denseMatrix64F.data, 0.0);
        for (int i = 0; i < denseMatrix64F.numCols; ++i) {
            denseMatrix64F.set(i, i, d);
        }
    }

    private static void checkSquare(DenseMatrix64F denseMatrix64F) {
        if (denseMatrix64F.numCols != denseMatrix64F.numRows) {
            throw new IllegalArgumentException("matrix must be square.");
        }
    }

    public static DenseMatrix64F computeRobustAdjugate(DenseMatrix64F denseMatrix64F) throws IllegalDimension {
        int n;
        int n2;
        if (DEBUG.booleanValue()) {
            System.out.println(denseMatrix64F);
        }
        EJMLUtils.checkSquare(denseMatrix64F);
        int n3 = denseMatrix64F.numRows;
        SingularValueDecomposition<DenseMatrix64F> singularValueDecomposition = DecompositionFactory.svd(n3, n3, true, true, true);
        singularValueDecomposition.decompose(denseMatrix64F);
        DenseMatrix64F denseMatrix64F2 = new DenseMatrix64F(n3, n3);
        DenseMatrix64F denseMatrix64F3 = new DenseMatrix64F(n3, n3);
        singularValueDecomposition.getU(denseMatrix64F2, true);
        singularValueDecomposition.getV(denseMatrix64F3, false);
        double[] dArray = singularValueDecomposition.getSingularValues();
        double d = CommonOps.det(denseMatrix64F2);
        double d2 = CommonOps.det(denseMatrix64F3);
        double[] dArray2 = new double[n3];
        double[] dArray3 = new double[n3];
        double[] dArray4 = new double[n3];
        double d3 = 1.0;
        double d4 = 1.0;
        for (n2 = 0; n2 < n3; ++n2) {
            dArray3[n2] = d3 *= dArray[n2];
            n = n3 - n2 - 1;
            dArray4[n] = d4 *= dArray[n];
        }
        dArray2[0] = dArray4[1];
        dArray2[n3 - 1] = dArray3[n3 - 2];
        for (n2 = 1; n2 < n3 - 1; ++n2) {
            dArray2[n2] = dArray3[n2 - 1] * dArray4[n2 + 1];
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n3; ++n) {
                denseMatrix64F2.set(n2, n, denseMatrix64F2.get(n2, n) * dArray2[n2]);
            }
        }
        DenseMatrix64F denseMatrix64F4 = new DenseMatrix64F(n3, n3);
        CommonOps.mult(denseMatrix64F3, denseMatrix64F2, denseMatrix64F4);
        CommonOps.scale(d * d2, denseMatrix64F4);
        if (DEBUG.booleanValue()) {
            System.out.println(denseMatrix64F4);
        }
        return denseMatrix64F4;
    }
}

