/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions.gp;

import dr.inference.distribution.RandomField;
import dr.inference.hmc.GradientWrtParameterProvider;
import dr.inference.model.CompoundParameter;
import dr.inference.model.DesignMatrix;
import dr.inference.model.GradientProvider;
import dr.inference.model.Likelihood;
import dr.inference.model.Parameter;
import dr.math.distributions.gp.AdditiveGaussianProcessDistribution;
import dr.math.distributions.gp.GaussianProcessKernel;
import dr.xml.Reportable;
import java.util.List;

public class GaussianProcessKernelGradient
implements GradientWrtParameterProvider,
Reportable {
    private final RandomField randomField;
    private final Parameter field;
    private final int dim;
    private final AdditiveGaussianProcessDistribution distribution;
    private final GaussianProcessKernel.Base kernel;
    private final DesignMatrix designMatrix1;
    private final DesignMatrix designMatrix2;
    private final GradientProvider provider;
    private final int parametersCount;
    private final Parameter hyperParameter;
    private final double[] matrix;
    private final boolean DEBUG = false;
    private final AdditiveGaussianProcessDistribution.BasisDimension basis;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GaussianProcessKernelGradient(RandomField randomField, AdditiveGaussianProcessDistribution.BasisDimension basisDimension, List<Parameter> list) {
        this.randomField = randomField;
        this.field = randomField.getField();
        this.dim = this.field.getDimension();
        this.basis = basisDimension;
        this.distribution = (AdditiveGaussianProcessDistribution)randomField.getDistribution();
        this.kernel = (GaussianProcessKernel.Base)basisDimension.getKernel();
        this.designMatrix1 = basisDimension.getDesignMatrix1();
        this.designMatrix2 = basisDimension.getDesignMatrix2();
        this.matrix = new double[this.dim * this.dim];
        List<Parameter> list2 = this.kernel.getParameters();
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        for (Parameter parameter : list) {
            if (parameter == list2.get(0)) {
                bl = true;
                ++n;
                continue;
            }
            if (parameter != list2.get(1)) continue;
            bl2 = true;
            ++n;
        }
        this.parametersCount = n;
        if (this.parametersCount == 1) {
            this.hyperParameter = list.get(0);
            if (bl) {
                this.provider = new GradientProvider(){

                    @Override
                    public int getDimension() {
                        return 1;
                    }

                    @Override
                    public double[] getGradientLogDensity(Object object) {
                        return new double[]{GaussianProcessKernelGradient.this.getGradientScale()};
                    }
                };
                return;
            } else {
                if (!bl2) throw new IllegalArgumentException("Gradient implemented only for scale or length");
                this.provider = new GradientProvider(){

                    @Override
                    public int getDimension() {
                        return 1;
                    }

                    @Override
                    public double[] getGradientLogDensity(Object object) {
                        return new double[]{GaussianProcessKernelGradient.this.getGradientLength()};
                    }
                };
            }
            return;
        } else {
            if (this.parametersCount != 2) throw new IllegalArgumentException("Gradient not implemented for more than 2 parameters");
            this.hyperParameter = new CompoundParameter(null);
            for (int i = 0; i < this.parametersCount; ++i) {
                ((CompoundParameter)this.hyperParameter).addParameter(list2.get(i));
            }
            this.provider = new GradientProvider(){

                @Override
                public int getDimension() {
                    return 2;
                }

                @Override
                public double[] getGradientLogDensity(Object object) {
                    double[] dArray = new double[]{GaussianProcessKernelGradient.this.getGradientScale(), GaussianProcessKernelGradient.this.getGradientLength()};
                    return dArray;
                }
            };
        }
    }

    public double getGradientScale() {
        return this.getGeneralGradient(this.kernel.getScale(), this.kernel.getScaleGradientFunction());
    }

    public double getGradientLength() {
        return this.getGeneralGradient(this.kernel.getLength(), this.kernel.getLengthGradientFunction());
    }

    @Override
    public Likelihood getLikelihood() {
        return this.randomField;
    }

    @Override
    public Parameter getParameter() {
        return this.hyperParameter;
    }

    @Override
    public int getDimension() {
        return this.parametersCount;
    }

    @Override
    public double[] getGradientLogDensity() {
        return this.provider.getGradientLogDensity(0.0);
    }

    private double getGeneralGradient(double d, GaussianProcessKernel.HyperparameterGradientFunction hyperparameterGradientFunction) {
        double[] dArray = this.distribution.getPrecision();
        double[] dArray2 = this.distribution.getPrecisionDiff(this.field.getParameterValues());
        for (int i = 0; i < this.dim; ++i) {
            double d2 = this.designMatrix1.getParameterValue(i, 0);
            for (int j = 0; j < this.dim; ++j) {
                double d3 = this.designMatrix2.getParameterValue(j, 0);
                double d4 = 1.0;
                if (this.basis.getWeightFunction() != null) {
                    double d5 = this.basis.getWeightFunction().getWeight(d2);
                    double d6 = this.basis.getWeightFunction().getWeight(d3);
                    d4 *= d5 * d6;
                }
                this.matrix[i * this.dim + j] = hyperparameterGradientFunction.apply(d2, d3, d) * d4;
            }
        }
        return this.computeGeneralGradient(dArray2, dArray, this.matrix, this.dim);
    }

    private double computeGeneralGradient(double[] dArray, double[] dArray2, double[] dArray3, int n) {
        double d = 0.0;
        double d2 = 0.0;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            double d3 = dArray[i];
            int n3 = 0;
            while (n3 < n) {
                double d4 = dArray[n3];
                double d5 = dArray3[n2];
                d += d3 * d5 * d4;
                d2 += dArray2[n2] * d5;
                ++n3;
                ++n2;
            }
        }
        return 0.5 * (d - d2);
    }

    @Override
    public String getReport() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("gradient:");
        for (double d : this.getGradientLogDensity()) {
            stringBuilder.append(" ").append(d);
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }
}

