/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.hmc;

import dr.inference.hmc.GradientWrtParameterProvider;
import dr.inference.model.Likelihood;
import dr.inference.model.Parameter;
import dr.math.MachineAccuracy;
import dr.math.matrixAlgebra.Vector;
import dr.util.Transform;
import dr.xml.Reportable;

public class GradientWrtIncrement
implements GradientWrtParameterProvider,
Reportable {
    private final GradientWrtParameterProvider gradient;
    private final Parameter incrementParameter;
    private final int dim;
    private final Transform incrementTransform;

    public GradientWrtIncrement(GradientWrtParameterProvider gradientWrtParameterProvider, Parameter parameter, Transform transform) {
        this.gradient = gradientWrtParameterProvider;
        this.incrementTransform = transform;
        this.incrementParameter = parameter;
        this.dim = gradientWrtParameterProvider.getDimension();
    }

    @Override
    public Likelihood getLikelihood() {
        return this.gradient.getLikelihood();
    }

    @Override
    public Parameter getParameter() {
        return this.incrementParameter;
    }

    @Override
    public int getDimension() {
        return this.dim;
    }

    public double[] parameterFromIncrements(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        dArray2[0] = dArray[0];
        for (int i = 1; i < dArray.length; ++i) {
            dArray2[i] = dArray2[i - 1] + dArray[i];
        }
        return this.incrementTransform.inverse(dArray2, 0, dArray.length);
    }

    @Override
    public double[] getGradientLogDensity() {
        double[] dArray = this.gradient.getGradientLogDensity();
        double[] dArray2 = this.parameterFromIncrements(this.incrementParameter.getParameterValues());
        double[] dArray3 = new double[this.dim];
        dArray3[this.dim - 1] = dArray[this.dim - 1] * this.incrementTransform.gradient(dArray2[this.dim - 1]);
        for (int i = this.dim - 2; i > -1; --i) {
            dArray3[i] = dArray[i] * this.incrementTransform.gradient(dArray2[i]) + dArray3[i + 1];
        }
        return dArray3;
    }

    @Override
    public String getReport() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Transform: ").append(this.incrementTransform.toString()).append("\n");
        stringBuilder.append("Gradient WRT increments: ").append(new Vector(this.getGradientLogDensity())).append("\n");
        stringBuilder.append("Gradient WRT parameters: ").append(new Vector(this.gradient.getGradientLogDensity())).append("\n");
        stringBuilder.append("Increments: ").append(new Vector(this.incrementParameter.getParameterValues())).append("\n");
        stringBuilder.append("Parameters: ").append(new Vector(this.parameterFromIncrements(this.incrementParameter.getParameterValues()))).append("\n");
        stringBuilder.append("Numerical gradient: ").append(new Vector(new GradientWrtParameterProvider.CheckGradientNumerically(this, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, MachineAccuracy.SQRT_EPSILON, MachineAccuracy.SQRT_EPSILON).getNumericalGradient())).append("\n");
        return stringBuilder.toString();
    }
}

