/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf;

import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfState;
import jdplus.toolkit.base.core.ssf.UpdateInformation;

public class State {
    public static final double ZERO = 1.0E-9;
    private final DataBlock a;
    private final FastMatrix P;

    public static State of(ISsfState ssf) {
        State state = new State(ssf.getStateDim());
        ssf.initialization().a0(state.a);
        ssf.initialization().Pf0(state.P);
        return state;
    }

    public State(int dim) {
        this.a = DataBlock.make(dim);
        this.P = FastMatrix.square(dim);
    }

    public State(DataBlock a, FastMatrix P) {
        this.a = a;
        this.P = P;
    }

    public void copy(State state) {
        this.a.copy(state.a);
        this.P.copy(state.P);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("mean:\r\n").append(this.a).append("\r\n");
        builder.append("covariance:\r\n").append(this.P);
        return builder.toString();
    }

    public final int getDim() {
        return this.a.length();
    }

    public final DataBlock a() {
        return this.a;
    }

    public final FastMatrix P() {
        return this.P;
    }

    public void next(int pos, ISsfDynamics dynamics) {
        dynamics.TX(pos, this.a);
        dynamics.TVT(pos, this.P);
        dynamics.addV(pos, this.P);
    }

    public void update(UpdateInformation updinfo) {
        double v = updinfo.getVariance();
        if (v == 0.0) {
            return;
        }
        double e = updinfo.get();
        DataBlock M = updinfo.M();
        this.a.addAY(e / v, M);
        this.P.addXaXt(-1.0 / v, M);
    }
}

