/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries;

import internal.toolkit.base.api.timeseries.InternalAggregator;
import java.util.Objects;
import java.util.Random;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;
import jdplus.toolkit.base.api.data.AggregationType;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.api.data.Doubles;
import jdplus.toolkit.base.api.data.HasEmptyCause;
import jdplus.toolkit.base.api.timeseries.TimeSelector;
import jdplus.toolkit.base.api.timeseries.TimeSeriesData;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.TsException;
import jdplus.toolkit.base.api.timeseries.TsObs;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.TsUnit;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class TsData
implements TimeSeriesData<TsPeriod, TsObs>,
HasEmptyCause {
    private static final String NO_DATA_CAUSE = "No data available";
    private final TsDomain domain;
    private final DoubleSeq values;
    private final @Nullable String emptyCause;

    public static TsData random(TsUnit freq, int seed) {
        Random rnd = new Random(seed);
        int beg = rnd.nextInt(240);
        int count = rnd.nextInt(600);
        double[] data = new double[count];
        double cur = rnd.nextDouble() + 100.0;
        for (int i = 0; i < count; ++i) {
            data[i] = cur = cur + rnd.nextDouble() - 0.5;
        }
        return TsData.of(TsPeriod.of(freq, beg), DoubleSeq.of(data));
    }

    @NonNull
    public static TsData of(@NonNull TsPeriod start, @NonNull DoubleSeq values) {
        if (start == null) {
            throw new NullPointerException("start is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        TsDomain domain = TsDomain.of(start, values.length());
        return domain.isEmpty() ? new TsData(domain, Doubles.EMPTY, NO_DATA_CAUSE) : new TsData(domain, values, null);
    }

    @NonNull
    public static TsData copyOf(@NonNull TsPeriod start, DoubleSeq.Mutable values) {
        if (start == null) {
            throw new NullPointerException("start is marked non-null but is null");
        }
        TsDomain domain = TsDomain.of(start, values.length());
        return domain.isEmpty() ? new TsData(domain, Doubles.EMPTY, NO_DATA_CAUSE) : new TsData(domain, DoubleSeq.of(values.toArray()), null);
    }

    @NonNull
    public static TsData ofInternal(@NonNull TsPeriod start, @NonNull double[] values) {
        if (start == null) {
            throw new NullPointerException("start is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        TsDomain domain = TsDomain.of(start, values.length);
        return domain.isEmpty() ? new TsData(domain, Doubles.EMPTY, NO_DATA_CAUSE) : new TsData(domain, DoubleSeq.of(values), null);
    }

    @NonNull
    public static TsData empty(@NonNull TsPeriod start, @NonNull String cause) {
        if (start == null) {
            throw new NullPointerException("start is marked non-null but is null");
        }
        if (cause == null) {
            throw new NullPointerException("cause is marked non-null but is null");
        }
        return new TsData(TsDomain.of(start, 0), Doubles.EMPTY, Objects.requireNonNull(cause));
    }

    @NonNull
    public static TsData empty(@NonNull String cause) {
        if (cause == null) {
            throw new NullPointerException("cause is marked non-null but is null");
        }
        return new TsData(TsDomain.DEFAULT_EMPTY, Doubles.EMPTY, Objects.requireNonNull(cause));
    }

    @Override
    public TsObs get(int index) throws IndexOutOfBoundsException {
        return TsObs.of((TsPeriod)this.getPeriod(index), this.getValue(index));
    }

    public TsUnit getTsUnit() {
        return this.domain.getTsUnit();
    }

    public TsPeriod getStart() {
        return this.domain.getStartPeriod();
    }

    public TsPeriod getEnd() {
        return this.domain.getEndPeriod();
    }

    public int getAnnualFrequency() {
        return this.domain.getTsUnit().getAnnualFrequency();
    }

    public boolean hasDefaultEpoch() {
        return this.domain.hasDefaultEpoch();
    }

    public double getDoubleValue(TsPeriod period) {
        int pos = this.domain.indexOf(period);
        return pos < 0 || pos >= this.values.length() ? Double.NaN : this.values.get(pos);
    }

    public TsData fn(DoubleUnaryOperator fn) {
        return TsData.ofInternal(this.getStart(), this.values.fn(fn).toArray());
    }

    public TsData fastFn(DoubleUnaryOperator fn) {
        return TsData.of(this.getStart(), DoubleSeq.onMapping(this.values.length(), i -> fn.applyAsDouble(this.values.get(i))));
    }

    public TsData commit() {
        return TsData.ofInternal(this.getStart(), this.values.toArray());
    }

    public TsData fastFn(@NonNull TsData right, DoubleBinaryOperator fn) {
        if (right == null) {
            throw new NullPointerException("right is marked non-null but is null");
        }
        TsDomain rDomain = right.getDomain();
        TsDomain iDomain = this.domain.intersection(rDomain);
        if (iDomain == null) {
            return null;
        }
        TsPeriod istart = iDomain.getStartPeriod();
        int li = this.domain.indexOf(istart);
        int ri = rDomain.indexOf(istart);
        return TsData.of(istart, DoubleSeq.onMapping(iDomain.length(), i -> fn.applyAsDouble(this.values.get(li + i), right.getValue(ri + i))));
    }

    public TsData fn(TsData right, DoubleBinaryOperator fn) {
        TsDomain rDomain = right.getDomain();
        TsDomain iDomain = this.domain.intersection(rDomain);
        if (iDomain == null) {
            return null;
        }
        TsPeriod istart = iDomain.getStartPeriod();
        int li = this.domain.indexOf(istart);
        int ri = rDomain.indexOf(istart);
        double[] data = new double[iDomain.length()];
        DoubleSeqCursor lreader = this.values.cursor();
        DoubleSeqCursor rreader = right.getValues().cursor();
        lreader.moveTo(li);
        rreader.moveTo(ri);
        for (int i = 0; i < data.length; ++i) {
            data[i] = fn.applyAsDouble(lreader.getAndNext(), rreader.getAndNext());
        }
        return TsData.ofInternal(istart, data);
    }

    public TsData fn(int lag, DoubleBinaryOperator fn) {
        return TsData.ofInternal(this.getStart().plus(lag), this.values.fn(lag, fn).toArray());
    }

    public TsData range(int beg, int end) {
        int len = this.length();
        TsPeriod start = this.getStart().plus(beg);
        if (beg >= len) {
            return TsData.of(start, Doubles.EMPTY);
        }
        return TsData.of(start, this.values.range(beg, Math.min(end, len)));
    }

    public TsData extract(int start, int n) {
        TsPeriod pstart = this.getStart().plus(start);
        return TsData.of(pstart, Doubles.of(this.values.extract(start, n)));
    }

    public TsData drop(int nbeg, int nend) {
        int len = this.length() - nbeg - nend;
        TsPeriod start = this.getStart().plus(nbeg);
        return TsData.of(start, this.values.extract(nbeg, Math.max(0, len)));
    }

    public TsData extend(int nbeg, int nend) {
        TsPeriod start = this.getStart().plus(-nbeg);
        return TsData.of(start, this.values.extend(nbeg, nend));
    }

    public TsData select(TimeSelector selector) {
        TsDomain ndomain = this.domain.select(selector);
        int beg = this.getStart().until(ndomain.getStartPeriod());
        return TsData.ofInternal(ndomain.getStartPeriod(), this.values.extract(beg, ndomain.length()).toArray());
    }

    public static TsData fitToDomain(TsData s, TsDomain domain) {
        int ncommon;
        int cur;
        if (s == null) {
            return null;
        }
        if (!s.getTsUnit().equals(domain.getStartPeriod().getUnit())) {
            throw new TsException("Incompatible frequencies");
        }
        TsDomain sdomain = s.getDomain();
        int nbeg = sdomain.getStartPeriod().until(domain.getStartPeriod());
        TsDomain idomain = domain.intersection(sdomain);
        double[] data = new double[domain.length()];
        if (nbeg < 0) {
            int cmax = Math.min(-nbeg, data.length);
            for (cur = 0; cur < cmax; ++cur) {
                data[cur] = Double.NaN;
            }
        }
        if ((ncommon = idomain.length()) > 0) {
            s.getValues().extract(sdomain.getStartPeriod().until(idomain.getStartPeriod()), ncommon).copyTo(data, cur);
            cur += ncommon;
        }
        while (cur < data.length) {
            data[cur] = Double.NaN;
            ++cur;
        }
        return TsData.ofInternal(domain.getStartPeriod(), data);
    }

    public TsData log() {
        return this.fastFn(Math::log);
    }

    public TsData exp() {
        return this.fastFn(Math::exp);
    }

    public TsData inv() {
        return this.fastFn(x -> 1.0 / x);
    }

    public TsData chs() {
        return this.fastFn(x -> -x);
    }

    public TsData abs() {
        return this.fastFn(Math::abs);
    }

    public static TsData add(TsData l, TsData r) {
        if (l == null) {
            return r;
        }
        if (r == null) {
            return l;
        }
        return l.fn(r, Double::sum);
    }

    public TsData add(double d) {
        if (d == 0.0) {
            return this;
        }
        return this.fastFn(x -> x + d);
    }

    public TsData subtract(double d) {
        if (d == 0.0) {
            return this;
        }
        return this.fastFn(x -> x - d);
    }

    public double distance(TsData r) {
        DoubleSeq diff = TsData.subtract(this, r).getValues();
        int n = diff.count(Double::isFinite);
        if (n == 0) {
            return Double.NaN;
        }
        return diff.fastNorm2();
    }

    public static TsData subtract(double d, TsData l) {
        if (d == 0.0) {
            return l == null ? null : l.chs();
        }
        return l.fastFn(x -> d - x);
    }

    public static TsData subtract(TsData l, TsData r) {
        if (l == null) {
            return r == null ? null : r.chs();
        }
        if (r == null) {
            return l;
        }
        return l.fastFn(r, (a, b) -> a - b);
    }

    public static TsData multiply(TsData a, TsData ... b) {
        TsData prod;
        int start = -1;
        if (b != null) {
            for (int i = 0; i < b.length; ++i) {
                if (b[i] == null) continue;
                start = i;
                break;
            }
        }
        if (start == -1) {
            return a;
        }
        if (a == null) {
            prod = b[start++];
            if (start == b.length) {
                return prod;
            }
        } else {
            prod = a;
        }
        for (int i = start; i < b.length; ++i) {
            prod = prod.fastFn(b[i], (x, y) -> x * y);
        }
        return prod.commit();
    }

    public static TsData add(TsData a, TsData ... b) {
        TsData prod;
        int start = -1;
        if (b != null) {
            for (int i = 0; i < b.length; ++i) {
                if (b[i] == null) continue;
                start = i;
                break;
            }
        }
        if (start == -1) {
            return a;
        }
        if (a == null) {
            prod = b[start++];
            if (start == b.length) {
                return prod;
            }
        } else {
            prod = a;
        }
        for (int i = start; i < b.length; ++i) {
            prod = prod.fastFn(b[i], Double::sum);
        }
        return prod.commit();
    }

    public TsData multiply(double d) {
        if (d == 1.0) {
            return this;
        }
        if (d == 0.0) {
            return this.fastFn(x -> 0.0);
        }
        return this.fastFn(x -> x * d);
    }

    public static TsData divide(TsData l, TsData r) {
        if (l == null) {
            return r.inv();
        }
        if (r == null) {
            return l;
        }
        return l.fastFn(r, (a, b) -> a / b);
    }

    public TsData divide(double d) {
        if (d == 1.0) {
            return this;
        }
        return this.fastFn(x -> x / d);
    }

    public static TsData divide(double d, TsData l) {
        return l.fastFn(x -> d / x);
    }

    public TsData delta(int lag) {
        return this.fn(lag, (double x, double y) -> y - x);
    }

    public TsData delta(int lag, int pow) {
        TsData ns = this;
        for (int i = 0; i < pow; ++i) {
            ns = ns.fn(lag, (double x, double y) -> y - x);
        }
        return ns;
    }

    public TsData pctVariation(int lag) {
        return this.fn(lag, (double x, double y) -> (y / x - 1.0) * 100.0);
    }

    public TsData normalize() {
        double[] data = this.values.toArray();
        DoubleSeq values = DoubleSeq.of(data);
        double mean = values.average();
        double ssqc = values.ssqc(mean);
        double std = Math.sqrt(ssqc / (double)values.length());
        for (int i = 0; i < data.length; ++i) {
            data[i] = (data[i] - mean) / std;
        }
        return TsData.ofInternal(this.getStart(), data);
    }

    public TsData lead(int lead) {
        return lead == 0 ? this : TsData.of(this.getStart().plus(-lead), this.values);
    }

    public TsData lag(int lag) {
        return lag == 0 ? this : TsData.of(this.getStart().plus(lag), this.values);
    }

    public static TsData update(TsData start, TsData end) {
        int i;
        TsDomain rdom;
        if (end == null || end.isEmpty()) {
            return start;
        }
        if (start == null || start.isEmpty()) {
            return end;
        }
        TsDomain ldom = start.getDomain();
        TsDomain udom = ldom.union(rdom = end.getDomain());
        if (udom == null) {
            return null;
        }
        TsPeriod pstart = start.getStart();
        TsPeriod pend = end.getStart();
        TsPeriod punion = udom.getStartPeriod();
        int n = udom.getLength();
        double[] data = new double[n];
        int l0 = punion.until(pstart);
        int l1 = punion.until(start.getEnd());
        int r0 = punion.until(pend);
        int r1 = punion.until(end.getEnd());
        for (i = l1; i < r0; ++i) {
            data[i] = Double.NaN;
        }
        for (i = r1; i < l0; ++i) {
            data[i] = Double.NaN;
        }
        start.getValues().copyTo(data, l0);
        end.getValues().copyTo(data, r0);
        return TsData.ofInternal(punion, data);
    }

    public static TsData concatenate(TsData ... s) {
        int ns = s.length;
        switch (ns) {
            case 0: {
                return null;
            }
            case 1: {
                return s[0];
            }
        }
        int n = 0;
        TsPeriod start = null;
        TsPeriod curPeriod = null;
        for (int i = 0; i < ns; ++i) {
            if (s[i] == null || s[i].isEmpty()) continue;
            TsPeriod cstart = s[i].getStart();
            if (start == null) {
                start = cstart;
            }
            if (curPeriod != null && !cstart.equals(curPeriod)) {
                throw new IllegalArgumentException();
            }
            n += s[i].length();
            curPeriod = s[i].getEnd();
        }
        if (n == 0) {
            return TsData.empty(NO_DATA_CAUSE);
        }
        double[] d = new double[n];
        int j = 0;
        for (int i = 0; i < ns; ++i) {
            if (s[i] == null) continue;
            s[i].getValues().copyTo(d, j);
            j += s[i].length();
        }
        return TsData.ofInternal(start, d);
    }

    public TsData cleanExtremities() {
        int nf;
        int nm;
        int n = this.values.length();
        if (n == (nm = this.values.count(x -> !Double.isFinite(x)))) {
            return this.drop(0, n);
        }
        int nl = 0;
        for (nf = 0; nf < n && !Double.isFinite(this.values.get(nf)); ++nf) {
        }
        while (nl < n && !Double.isFinite(this.values.get(n - nl - 1))) {
            ++nl;
        }
        return this.drop(nf, nl);
    }

    public String toString() {
        if (this.isEmpty()) {
            return "Empty due to: '" + this.emptyCause + "'";
        }
        StringBuilder builder = new StringBuilder();
        DoubleSeqCursor reader = this.values.cursor();
        for (int i = 0; i < this.values.length(); ++i) {
            builder.append(this.domain.get(i).getStartAsShortString()).append('\t').append(reader.getAndNext());
            builder.append(System.lineSeparator());
        }
        return builder.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.emptyCause == null ? 0 : this.emptyCause.hashCode());
        result = 31 * result + this.domain.hashCode();
        result = 31 * result + DoubleSeq.getHashCode(this.values);
        return result;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof TsData && this.equals((TsData)that);
    }

    private boolean equals(TsData that) {
        return Objects.equals(this.emptyCause, that.emptyCause) && this.domain.equals(that.domain) && this.values.hasSameContentAs(that.values);
    }

    @NonNull
    public TsData aggregate(@NonNull TsUnit newUnit, @NonNull AggregationType conversion, boolean complete) throws TsException {
        if (newUnit == null) {
            throw new NullPointerException("newUnit is marked non-null but is null");
        }
        if (conversion == null) {
            throw new NullPointerException("conversion is marked non-null but is null");
        }
        int ratio = this.getTsUnit().ratioOf(newUnit);
        switch (ratio) {
            case -1: 
            case 0: {
                throw new TsException("Incompatible frequencies");
            }
            case 1: {
                return this;
            }
        }
        if (this.isEmpty()) {
            return TsData.of(this.getStart().withUnit(newUnit), this.getValues());
        }
        return TsData.aggregateUsingRatio(this, newUnit, conversion, ratio, complete);
    }

    @NonNull
    public TsData aggregateByPosition(@NonNull TsUnit newUnit, int position) throws TsException {
        if (newUnit == null) {
            throw new NullPointerException("newUnit is marked non-null but is null");
        }
        int ratio = this.getTsUnit().ratioOf(newUnit);
        switch (ratio) {
            case -1: 
            case 0: {
                throw new TsException("Incompatible frequencies");
            }
            case 1: {
                return this;
            }
        }
        if (position < 0 || position >= ratio) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return TsData.of(this.getStart().withUnit(newUnit), this.getValues());
        }
        return TsData.aggregateByPositionUsingRatio(this, newUnit, position, ratio);
    }

    private static TsData aggregateUsingRatio(TsData data, TsUnit newUnit, AggregationType conversion, int ratio, boolean complete) {
        int oldLength = data.length();
        TsPeriod oldStart = data.getStart();
        TsPeriod newStart = oldStart.withUnit(newUnit);
        int offset = TsData.getAggregationOffset(newStart, oldStart);
        int head = offset > 0 ? Math.min(ratio - offset, oldLength) : 0;
        int tail = (oldLength - head) % ratio;
        int body = oldLength - head - tail;
        if (complete && head > 0) {
            newStart = newStart.next();
        }
        return TsData.of(newStart, TsData.aggregateUsingRatio(data.getValues(), InternalAggregator.of(conversion), complete, ratio, head, body, tail));
    }

    private static TsData aggregateByPositionUsingRatio(TsData data, TsUnit newUnit, int position, int ratio) {
        int oldLength = data.length();
        TsPeriod oldStart = data.getStart();
        TsPeriod newStart = oldStart.withUnit(newUnit);
        int offset = TsData.getAggregationOffset(newStart, oldStart);
        int head = position - offset;
        if (head < 0) {
            head += ratio;
            newStart = newStart.next();
        }
        return TsData.of(newStart, TsData.aggregateByPositionUsingRatio(data.getValues(), ratio, head, oldLength));
    }

    private static int getAggregationOffset(TsPeriod newStart, TsPeriod oldStart) {
        return TsDomain.splitOf(newStart, oldStart.getUnit(), false).indexOf(oldStart);
    }

    private static DoubleSeq aggregateUsingRatio(DoubleSeq values, InternalAggregator aggregator, boolean complete, int ratio, int head, int body, int tail) {
        boolean appendHead = !complete && head > 0;
        boolean appendTail = !complete && tail > 0;
        int length = body / ratio + (appendHead ? 1 : 0) + (appendTail ? 1 : 0);
        double[] safeArray = new double[length];
        int i = 0;
        if (appendHead) {
            safeArray[i++] = aggregator.aggregate(values, 0, head);
        }
        int tailIndex = body + head;
        for (int j = head; j < tailIndex; j += ratio) {
            safeArray[i++] = aggregator.aggregate(values, j, j + ratio);
        }
        if (appendTail) {
            safeArray[i++] = aggregator.aggregate(values, tailIndex, tailIndex + tail);
        }
        return DoubleSeq.of(safeArray);
    }

    private static DoubleSeq aggregateByPositionUsingRatio(DoubleSeq values, int ratio, int head, int oldLength) {
        int length = 1 + (oldLength - head - 1) / ratio;
        return Doubles.of(values.extract(head, length, ratio));
    }

    @Generated
    public TsDomain getDomain() {
        return this.domain;
    }

    @Override
    @Generated
    public DoubleSeq getValues() {
        return this.values;
    }

    @Override
    @Generated
    public @Nullable String getEmptyCause() {
        return this.emptyCause;
    }

    @Generated
    private TsData(TsDomain domain, DoubleSeq values, @Nullable String emptyCause) {
        this.domain = domain;
        this.values = values;
        this.emptyCause = emptyCause;
    }
}

