/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import java.util.List;
import java.util.Objects;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Decorable;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Extension;
import org.dmg.pmml.Field;
import org.dmg.pmml.Interval;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Output;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.PMMLElements;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Value;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.converter.CategoricalFeature;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.ObjectFeature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.model.MissingElementException;

public class DerivedOutputField
extends DerivedField
implements Decorable {
    private Model model = null;
    private OutputField outputField = null;
    private boolean required = false;

    public DerivedOutputField(Model model, OutputField outputField, boolean required) {
        this.setModel(model);
        this.setOutputField(outputField);
        this.setRequired(required);
    }

    public String requireName() {
        OutputField outputField = this.getOutputField();
        return outputField.requireName();
    }

    public String getName() {
        OutputField outputField = this.getOutputField();
        return outputField.getName();
    }

    public DerivedOutputField setName(String name) {
        OutputField outputField = this.getOutputField();
        outputField.setName(name);
        return this;
    }

    public String getDisplayName() {
        OutputField outputField = this.getOutputField();
        return outputField.getDisplayName();
    }

    public DerivedOutputField setDisplayName(String displayName) {
        OutputField outputField = this.getOutputField();
        outputField.setDisplayName(displayName);
        return this;
    }

    public OpType requireOpType() {
        OutputField outputField = this.getOutputField();
        return outputField.requireOpType();
    }

    public OpType getOpType() {
        OutputField outputField = this.getOutputField();
        return outputField.getOpType();
    }

    public DerivedOutputField setOpType(OpType opType) {
        OutputField outputField = this.getOutputField();
        outputField.setOpType(opType);
        return this;
    }

    public DataType requireDataType() {
        OutputField outputField = this.getOutputField();
        return outputField.requireDataType();
    }

    public DataType getDataType() {
        OutputField outputField = this.getOutputField();
        return outputField.getDataType();
    }

    public DerivedOutputField setDataType(DataType dataType) {
        OutputField outputField = this.getOutputField();
        outputField.setDataType(dataType);
        return this;
    }

    public boolean hasExtensions() {
        OutputField outputField = this.getOutputField();
        return outputField.hasExtensions();
    }

    public List<Extension> getExtensions() {
        OutputField outputField = this.getOutputField();
        return outputField.getExtensions();
    }

    public Expression requireExpression() {
        throw new MissingElementException((PMMLObject)this, PMMLElements.DERIVEDFIELD_EXPRESSION);
    }

    public Expression getExpression() {
        return null;
    }

    public DerivedOutputField setExpression(Expression expression) {
        throw new UnsupportedOperationException();
    }

    public boolean hasIntervals() {
        return false;
    }

    public List<Interval> getIntervals() {
        throw new UnsupportedOperationException();
    }

    public boolean hasValues() {
        OutputField outputField = this.getOutputField();
        return outputField.hasValues();
    }

    public List<Value> getValues() {
        OutputField outputField = this.getOutputField();
        return outputField.getValues();
    }

    public void addOutputField() {
        this.addOutputField(-1);
    }

    public void addOutputField(int index) {
        Model model = this.getModel();
        OutputField outputField = this.getOutputField();
        Output output = ModelUtil.ensureOutput(model);
        List outputFields = output.getOutputFields();
        if (index > -1) {
            outputFields.add(index, outputField);
        } else {
            outputFields.add(outputField);
        }
    }

    public Feature toFeature(PMMLEncoder encoder) {
        OpType opType = this.requireOpType();
        switch (opType) {
            case CONTINUOUS: {
                return new ContinuousFeature(encoder, (Field<?>)this);
            }
            case CATEGORICAL: {
                if (this.hasValues()) {
                    return new CategoricalFeature(encoder, this);
                }
                return new ObjectFeature(encoder, (Field)this){

                    @Override
                    public ContinuousFeature toContinuousFeature() {
                        PMMLEncoder encoder = this.getEncoder();
                        Field<?> field = encoder.toContinuous(this.getName());
                        return new ContinuousFeature(encoder, field);
                    }
                };
            }
        }
        throw new IllegalArgumentException();
    }

    public Model getModel() {
        return this.model;
    }

    private void setModel(Model model) {
        this.model = Objects.requireNonNull(model);
    }

    public OutputField getOutputField() {
        return this.outputField;
    }

    private void setOutputField(OutputField outputField) {
        this.outputField = Objects.requireNonNull(outputField);
    }

    public boolean isRequired() {
        return this.required;
    }

    private void setRequired(boolean required) {
        this.required = required;
    }

    public VisitorAction accept(Visitor visitor) {
        return super.accept(visitor);
    }
}

