/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.functions;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.functions.IParametricMapping;
import jdplus.toolkit.base.core.math.functions.ParamValidation;

public class PartialMapping<S>
implements IParametricMapping<S> {
    private final IParametricMapping<S> mapping;
    private double[] refp;
    private boolean[] fp;
    private int nfixed;

    public PartialMapping(IParametricMapping<S> mapping, DoubleSeq p, DoubleSeq pfixed) {
        this.mapping = mapping;
        this.refp = pfixed.toArray();
        this.fp = new boolean[this.refp.length];
        int n = 0;
        DoubleSeqCursor reader = p.cursor();
        for (int i = 0; i < this.refp.length; ++i) {
            if (this.refp[i] == reader.getAndNext()) continue;
            this.fp[i] = true;
            ++n;
        }
        this.nfixed = n;
    }

    private double[] narray(DoubleSeq p) {
        double[] np = (double[])this.refp.clone();
        DoubleSeqCursor reader = p.cursor();
        for (int i = 0; i < np.length; ++i) {
            if (this.fp[i]) continue;
            np[i] = reader.getAndNext();
        }
        return np;
    }

    public DoubleSeq convert(DoubleSeq p) {
        return DoubleSeq.of((double[])this.narray(p));
    }

    private int pos(int idx) {
        int j = 0;
        for (int i = 0; i < this.fp.length; ++i) {
            if (this.fp[i]) continue;
            if (idx == j) {
                return i;
            }
            ++j;
        }
        return -1;
    }

    @Override
    public S map(DoubleSeq p) {
        return this.mapping.map(this.convert(p));
    }

    @Override
    public DoubleSeq getDefaultParameters() {
        return this.convert(this.mapping.getDefaultParameters());
    }

    @Override
    public boolean checkBoundaries(DoubleSeq inparams) {
        return this.mapping.checkBoundaries(this.convert(inparams));
    }

    @Override
    public double epsilon(DoubleSeq inparams, int idx) {
        return this.mapping.epsilon(this.convert(inparams), this.pos(idx));
    }

    @Override
    public int getDim() {
        return this.mapping.getDim() - this.nfixed;
    }

    @Override
    public double lbound(int idx) {
        return this.mapping.lbound(this.pos(idx));
    }

    @Override
    public double ubound(int idx) {
        return this.mapping.ubound(this.pos(idx));
    }

    @Override
    public ParamValidation validate(DataBlock ioparams) {
        double[] narray = this.narray((DoubleSeq)ioparams);
        DataBlock a = DataBlock.of(narray);
        ParamValidation rslt = this.mapping.validate(a);
        if (rslt == ParamValidation.Changed) {
            int nj = narray.length - this.nfixed;
            int i = 0;
            int j = 0;
            while (j < nj) {
                if (!this.fp[i]) {
                    ioparams.set(j++, narray[i]);
                }
                ++i;
            }
        }
        return rslt;
    }
}

